/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import android.content.Context;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.PanoAnnotationManager;
import com.pano.rtc.api.RtcAudioDeviceManager;
import com.pano.rtc.api.RtcAudioIndication;
import com.pano.rtc.api.RtcAudioMixingMgr;
import com.pano.rtc.api.RtcChannelConfig;
import com.pano.rtc.api.RtcEngineConfig;
import com.pano.rtc.api.RtcExternalAudioPlayer;
import com.pano.rtc.api.RtcExternalAudioRecorder;
import com.pano.rtc.api.RtcGroupManager;
import com.pano.rtc.api.RtcMediaStatsObserver;
import com.pano.rtc.api.RtcMessageService;
import com.pano.rtc.api.RtcNetworkManager;
import com.pano.rtc.api.RtcRemoteController;
import com.pano.rtc.api.RtcScreenConfig;
import com.pano.rtc.api.RtcSnapshotVideoOption;
import com.pano.rtc.api.RtcVideoConfig;
import com.pano.rtc.api.RtcVideoDeviceManager;
import com.pano.rtc.api.RtcVideoStreamManager;
import com.pano.rtc.api.RtcWhiteboard;
import com.pano.rtc.impl.RtcEngineImpl;
import java.util.List;
import video.pano.rtc.base.util.SystemPermissionUtils;

public abstract class RtcEngine {
    public static RtcEngine create(RtcEngineConfig config) throws Exception {
        if (config.context == null || !RtcEngineImpl.initNativeLibs()) {
            return null;
        }
        RtcEngineImpl rtcEngine = new RtcEngineImpl(config);
        if (rtcEngine.initialize(config) != Constants.QResult.OK) {
            return null;
        }
        return rtcEngine;
    }

    public abstract void destroy();

    public abstract Constants.QResult setLocalVideoRender(IVideoRender var1);

    public abstract Constants.QResult setRemoteVideoRender(long var1, IVideoRender var3);

    public abstract Constants.QResult setRemoteScreenRender(long var1, IVideoRender var3);

    public abstract Constants.QResult joinChannel(String var1, String var2, long var3, RtcChannelConfig var5);

    public abstract Constants.QResult leaveChannel();

    public abstract Constants.QResult startAudio();

    public abstract Constants.QResult stopAudio();

    public abstract Constants.QResult startVideo(Constants.VideoProfileType var1, boolean var2);

    public abstract Constants.QResult startScreen();

    public abstract Constants.QResult startScreen(RtcScreenConfig var1);

    public abstract Constants.QResult stopScreen();

    public abstract Constants.QResult updateScreenConfig(RtcScreenConfig var1);

    public abstract Constants.QResult startVideo(boolean var1, RtcVideoConfig var2);

    public abstract Constants.QResult stopVideo();

    public abstract Constants.QResult startPreview(Constants.VideoProfileType var1, boolean var2);

    public abstract Constants.QResult switchCamera();

    public abstract Constants.QResult stopPreview();

    public abstract Constants.QResult subscribeAudio(long var1);

    public abstract Constants.QResult unsubscribeAudio(long var1);

    public abstract Constants.QResult subscribeVideo(long var1, Constants.VideoProfileType var3);

    public abstract Constants.QResult unsubscribeVideo(long var1);

    public abstract Constants.QResult muteAudio();

    public abstract Constants.QResult unmuteAudio();

    public abstract Constants.QResult muteVideo();

    public abstract Constants.QResult unmuteVideo();

    public abstract Constants.QResult subscribeScreen(long var1);

    public abstract Constants.QResult unsubscribeScreen(long var1);

    public abstract Constants.QResult setLoudspeakerStatus(boolean var1);

    public abstract boolean isLoudspeakerOn();

    public abstract Constants.QResult setMicrophoneMuteStatus(boolean var1);

    public abstract Constants.QResult setRecordDeviceVolume(int var1);

    public abstract int getRecordDeviceVolume();

    public abstract Constants.QResult setPlayoutDeviceVolume(int var1);

    public abstract int getPlayoutDeviceVolume();

    public abstract int getRecordingLevel();

    public abstract int getPlayoutLevel();

    public abstract RtcWhiteboard getWhiteboard();

    public abstract RtcWhiteboard getWhiteboardById(String var1);

    public abstract Constants.QResult switchWhiteboard(String var1);

    public abstract PanoAnnotationManager getAnnotationMgr();

    public abstract RtcAudioMixingMgr getAudioMixingMgr();

    public abstract RtcNetworkManager getNetworkManager();

    public abstract RtcExternalAudioRecorder getExternalAudioRecorder();

    public abstract RtcExternalAudioPlayer getExternalAudioPlayer();

    public abstract RtcAudioDeviceManager getAudioDeviceManager();

    public abstract RtcVideoStreamManager getVideoStreamManager();

    public abstract RtcVideoDeviceManager getVideoDeviceManager();

    public abstract RtcMessageService getMessageService();

    public abstract RtcRemoteController getRemoteController();

    public abstract RtcGroupManager getGroupManager();

    public abstract Constants.QResult setMediaStatsObserver(RtcMediaStatsObserver var1);

    public abstract Constants.QResult setAudioIndication(RtcAudioIndication var1, int var2);

    public abstract Constants.QResult setFaceBeautify(boolean var1);

    public abstract Constants.QResult setFaceBeautifyIntensity(float var1);

    public abstract Constants.QResult setMediaProcessor(Constants.MediaProcessorType var1, Object var2, Object var3);

    public abstract Constants.QResult setDeviceBoundMediaProcessor(String var1, Constants.MediaProcessorType var2, Object var3, Object var4);

    public abstract Constants.QResult setOption(Constants.PanoOptionType var1, Object var2);

    public abstract Constants.QResult setDeviceBoundOption(String var1, Constants.PanoOptionType var2, Object var3);

    public abstract Constants.QResult snapshotVideo(String var1, long var2, RtcSnapshotVideoOption var4);

    public abstract Constants.QResult startAudioDump(long var1);

    public abstract Constants.QResult stopAudioDump();

    public abstract Constants.QResult setAudioEqualization(Constants.AudioEqualizationMode var1);

    public abstract Constants.QResult setAudioReverb(Constants.AudioReverbMode var1);

    public abstract Constants.QResult setAudioEarMonitoring(boolean var1);

    public abstract Constants.QResult setVideoFrameRate(Constants.VideoFrameRateType var1);

    public abstract Constants.QResult enableUploadDebugLogs(boolean var1);

    public abstract Constants.QResult enableUploadAudioDump(boolean var1);

    public abstract Constants.QResult sendFeedback(FeedbackInfo var1);

    public abstract Constants.QResult sendAudioControlMessage(byte[] var1);

    public abstract Constants.DeviceRating queryDeviceRating();

    public abstract Constants.QResult setParameters(String var1);

    public abstract Constants.QResult callout(String var1, boolean var2);

    public abstract Constants.QResult dropCall(String var1);

    public abstract String getSdkVersion();

    public abstract long getNativeHandle();

    public static List<String> checkPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context);
    }

    public static final class FeedbackInfo {
        public Constants.FeedbackType type;
        public String productName;
        public String description;
        public String contact;
        public String extraInfo;
        public boolean uploadLogs;
    }
}

