/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.api;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.RtcSnapshotVideoOption;

public interface RtcVideoStreamManager {
    public Constants.QResult setCallback(Callback var1);

    public int createVideoStream(String var1);

    public Constants.QResult destroyVideoStream(int var1);

    public Constants.QResult setCaptureDevice(int var1, String var2);

    public String getCaptureDevice(int var1);

    public Constants.QResult setLocalVideoRender(int var1, IVideoRender var2);

    public Constants.QResult setRemoteVideoRender(long var1, int var3, IVideoRender var4);

    public Constants.QResult startVideo(int var1, Constants.VideoProfileType var2);

    public Constants.QResult stopVideo(int var1);

    public Constants.QResult muteVideo(int var1);

    public Constants.QResult unmuteVideo(int var1);

    public Constants.QResult subscribeVideo(long var1, int var3, Constants.VideoProfileType var4);

    public Constants.QResult unsubscribeVideo(long var1, int var3);

    public Constants.QResult snapshotVideo(long var1, int var3, String var4, RtcSnapshotVideoOption var5);

    public Constants.QResult setOption(int var1, Constants.PanoOptionType var2, Object var3);

    public static interface Callback {
        default public void onUserVideoStart(long userId, int streamId, Constants.VideoProfileType maxProfile) {
        }

        default public void onUserVideoStop(long userId, int streamId) {
        }

        default public void onUserVideoSubscribe(long userId, int streamId, Constants.MediaSubscribeResult result) {
        }

        default public void onUserVideoMute(long userId, int streamId) {
        }

        default public void onUserVideoUnmute(long userId, int streamId) {
        }

        default public void onFirstVideoDataReceived(long userId, int streamId) {
        }

        default public void onFirstVideoFrameRendered(long userId, int streamId) {
        }

        default public void onVideoSnapshotCompleted(long userId, int streamId, boolean succeed, String filename) {
        }

        default public void onVideoCaptureStateChanged(int streamId, String deviceId, Constants.VideoCaptureState state) {
        }

        default public void onVideoStartResult(int streamId, Constants.QResult result) {
        }
    }
}

