/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.Display;
import android.view.WindowManager;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.RtcVideoDeviceManager;
import com.pano.rtc.api.RtcView;
import video.pano.VideoSink;
import video.pano.rtc.impl.GlobalRef;

public class CameraControllerImpl
implements RtcVideoDeviceManager.CameraController {
    private final long mNativeHandle;
    private final String mDeviceId;
    private final Display mDisplay;
    private RtcView mPreviewRender;

    CameraControllerImpl(long nativeHandle, String deviceId) {
        this.mNativeHandle = nativeHandle;
        this.mDeviceId = deviceId;
        this.mDisplay = ((WindowManager)GlobalRef.applicationContext.getSystemService("window")).getDefaultDisplay();
    }

    void setPreviewRender(VideoSink render) {
        if (render instanceof RtcView) {
            this.mPreviewRender = (RtcView)render;
        }
    }

    @Override
    public boolean isCameraFocusSupported() {
        return this.isCameraFocusSupported(this.mNativeHandle, this.mDeviceId);
    }

    @Override
    public Constants.QResult setCameraFocusPointInPreview(float x, float y) {
        if (this.mPreviewRender == null || this.mPreviewRender.getScalingType() != IVideoRender.ScalingType.SCALE_ASPECT_ADJUST) {
            return Constants.QResult.InvalidState;
        }
        int paddingX = (this.mPreviewRender.getWidth() - this.mPreviewRender.getViewPortWidth()) / 2;
        if (x < (float)paddingX || x > (float)(paddingX + this.mPreviewRender.getViewPortWidth())) {
            return Constants.QResult.InvalidArgs;
        }
        int paddingY = (this.mPreviewRender.getHeight() - this.mPreviewRender.getViewPortHeight()) / 2;
        if (y < (float)paddingY || y > (float)(paddingY + this.mPreviewRender.getViewPortHeight())) {
            return Constants.QResult.InvalidArgs;
        }
        int rotation = this.mDisplay.getRotation();
        float posX = 0.0f;
        float posY = 0.0f;
        if (rotation == 0 || rotation == 2) {
            posX = 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
            posY = 1.0f - 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
        } else if (rotation == 1) {
            posX = 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
            posY = 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
        } else if (rotation == 3) {
            posX = 1.0f - 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
            posY = 1.0f - 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
        }
        if (this.mPreviewRender.getMirror()) {
            posX = 1.0f - posX;
        }
        return Constants.QResult.valueOf(this.setCameraFocusPointInPreview(this.mNativeHandle, posX, posY, this.mDeviceId));
    }

    @Override
    public boolean isCameraExposureSupported() {
        return this.isCameraExposureSupported(this.mNativeHandle, this.mDeviceId);
    }

    @Override
    public Constants.QResult setCameraExposurePointInPreview(float x, float y) {
        if (this.mPreviewRender == null || this.mPreviewRender.getScalingType() != IVideoRender.ScalingType.SCALE_ASPECT_ADJUST) {
            return Constants.QResult.InvalidState;
        }
        int paddingX = (this.mPreviewRender.getWidth() - this.mPreviewRender.getViewPortWidth()) / 2;
        if (x < (float)paddingX || x > (float)(paddingX + this.mPreviewRender.getViewPortWidth())) {
            return Constants.QResult.InvalidArgs;
        }
        int paddingY = (this.mPreviewRender.getHeight() - this.mPreviewRender.getViewPortHeight()) / 2;
        if (y < (float)paddingY || y > (float)(paddingY + this.mPreviewRender.getViewPortHeight())) {
            return Constants.QResult.InvalidArgs;
        }
        float posX = 0.0f;
        float posY = 0.0f;
        int rotation = this.mDisplay.getRotation();
        if (rotation == 0 || rotation == 2) {
            posX = 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
            posY = 1.0f - 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
        } else if (rotation == 1) {
            posX = 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
            posY = 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
        } else if (rotation == 3) {
            posX = 1.0f - 1.0f * (x - (float)paddingX) / (float)this.mPreviewRender.getViewPortWidth();
            posY = 1.0f - 1.0f * (y - (float)paddingY) / (float)this.mPreviewRender.getViewPortHeight();
        }
        if (this.mPreviewRender.getMirror()) {
            posX = 1.0f - posX;
        }
        return Constants.QResult.valueOf(this.setCameraExposurePointInPreview(this.mNativeHandle, posX, posY, this.mDeviceId));
    }

    private native boolean isCameraFocusSupported(long var1, String var3);

    private native int setCameraFocusPointInPreview(long var1, float var3, float var4, String var5);

    private native boolean isCameraExposureSupported(long var1, String var3);

    private native int setCameraExposurePointInPreview(long var1, float var3, float var4, String var5);
}

