/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcAudioDataFormat;
import com.pano.rtc.api.RtcExternalAudioPlayer;
import java.nio.ByteBuffer;

class ExternalAudioPlayerImpl
implements RtcExternalAudioPlayer {
    private final long mNativeHandle;
    private ByteBuffer mBuffer;

    ExternalAudioPlayerImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    boolean getEnableStatus() {
        return this.getEnableStatus(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setEnableStatus(boolean enable, int sampleRate, int channels) {
        int ret = this.setEnableStatus(this.mNativeHandle, enable, sampleRate, channels);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult pullData(ByteBuffer buffer, RtcAudioDataFormat format) {
        int ret = this.pullData(this.mNativeHandle, buffer, format);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult pullData(byte[] buffer, RtcAudioDataFormat format) {
        if (this.mBuffer == null || this.mBuffer.capacity() != buffer.length) {
            this.mBuffer = ByteBuffer.allocateDirect(buffer.length);
        }
        this.mBuffer.clear();
        Constants.QResult ret = this.pullData(this.mBuffer, format);
        if (ret == Constants.QResult.OK) {
            this.mBuffer.flip();
            this.mBuffer.get(buffer);
        }
        return ret;
    }

    private native int setEnableStatus(long var1, boolean var3, int var4, int var5);

    private native int pullData(long var1, ByteBuffer var3, RtcAudioDataFormat var4);

    private native boolean getEnableStatus(long var1);
}

