/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoAnnotation;
import com.pano.rtc.api.PanoAnnotationManager;
import com.pano.rtc.impl.PanoAnnotationImpl;
import java.util.HashMap;
import java.util.Map;
import video.pano.rtc.impl.PLogger;
import video.pano.rtc.impl.whiteboard.PanoAnnoMgrCallbackImpl;

public class PanoAnnotationMgrImpl
implements PanoAnnotationManager,
PanoAnnoMgrCallbackImpl {
    private static final String TAG = "[pano]";
    private static final String kAnnotationIdPrefix = "pano-annotation-ext-";
    private static final String kVideoAnnotationIdPrefix = "pano-annotation-video-";
    private static final String kShareAnnotationIdPrefix = "pano-annotation-share-";
    private long mNativeHandle;
    private PanoAnnotationManager.Callback mCallback;
    private final Map<String, PanoAnnotationImpl> mVideoAnnoMap;
    private final Map<String, PanoAnnotationImpl> mShareAnnoMap;
    private final Map<String, PanoAnnotationImpl> mExternalAnnoMap;

    public PanoAnnotationMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mVideoAnnoMap = new HashMap<String, PanoAnnotationImpl>();
        this.mShareAnnoMap = new HashMap<String, PanoAnnotationImpl>();
        this.mExternalAnnoMap = new HashMap<String, PanoAnnotationImpl>();
    }

    void destroy() {
        for (PanoAnnotationImpl annotation : this.mVideoAnnoMap.values()) {
            annotation.destroy();
        }
        this.mVideoAnnoMap.clear();
        for (PanoAnnotationImpl annotation : this.mShareAnnoMap.values()) {
            annotation.destroy();
        }
        this.mShareAnnoMap.clear();
        for (PanoAnnotationImpl annotation : this.mExternalAnnoMap.values()) {
            annotation.destroy();
        }
        this.mExternalAnnoMap.clear();
        this.mNativeHandle = 0L;
    }

    @Override
    public Constants.QResult setCallback(PanoAnnotationManager.Callback callback) {
        this.mCallback = callback;
        this.AnnoMgrSetCallback(this.mNativeHandle, this);
        return Constants.QResult.OK;
    }

    @Override
    public PanoAnnotation getVideoAnnotation(long userId, int streamId) {
        String annotationId = kVideoAnnotationIdPrefix + userId + "-" + streamId;
        PanoAnnotationImpl annotation = this.mVideoAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoAnnotationImpl(this.mNativeHandle, annotationId);
            this.mVideoAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public PanoAnnotation getShareAnnotation(long userId) {
        String annotationId = kShareAnnotationIdPrefix + userId;
        PanoAnnotationImpl annotation = this.mShareAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoAnnotationImpl(this.mNativeHandle, annotationId);
            this.mShareAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public PanoAnnotation getExternalAnnotation(String annotationId) {
        if (!annotationId.startsWith(kAnnotationIdPrefix)) {
            return null;
        }
        PanoAnnotationImpl annotation = this.mExternalAnnoMap.get(annotationId);
        if (null == annotation) {
            annotation = new PanoAnnotationImpl(this.mNativeHandle, annotationId);
            this.mExternalAnnoMap.put(annotationId, annotation);
        }
        return annotation;
    }

    @Override
    public void onVideoAnnotationStart(long userId, int streamId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onVideoAnnotationStart " + userId + ", " + streamId);
        if (this.mCallback != null) {
            this.mCallback.onVideoAnnotationStart(userId, streamId);
        }
    }

    @Override
    public void onVideoAnnotationStop(long userId, int streamId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onVideoAnnotationStop " + userId + ", " + streamId);
        if (this.mCallback != null) {
            this.mCallback.onVideoAnnotationStop(userId, streamId);
        }
    }

    @Override
    public void onShareAnnotationStart(long userId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onShareAnnotationStart " + userId);
        if (this.mCallback != null) {
            this.mCallback.onShareAnnotationStart(userId);
        }
    }

    @Override
    public void onShareAnnotationStop(long userId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onShareAnnotationStop " + userId);
        if (this.mCallback != null) {
            this.mCallback.onShareAnnotationStop(userId);
        }
    }

    @Override
    public void onExternalAnnotationStart(String annotationId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onExternalAnnotationStart " + annotationId);
        if (this.mCallback != null) {
            this.mCallback.onExternalAnnotationStart(annotationId);
        }
    }

    @Override
    public void onExternalAnnotationStop(String annotationId) {
        PLogger.i(TAG, "PanoAnnotationMgrImpl.onExternalAnnotationStop " + annotationId);
        if (this.mCallback != null) {
            this.mCallback.onExternalAnnotationStop(annotationId);
        }
    }

    private native int AnnoMgrSetCallback(long var1, PanoAnnoMgrCallbackImpl var3);
}

