/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.PanoCoursePageView;
import com.pano.rtc.api.RtcEngine;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.api.RtcWhiteboard;

public class PanoCoursePageFactory {
    private long mNativeHandle = 0L;
    private RtcEngine mEngine;

    public PanoCoursePageFactory(long nativeHandle, RtcEngine engine) {
        this.mNativeHandle = nativeHandle;
        this.mEngine = engine;
    }

    private RtcWbView getRtcWbViewById(String pageId) {
        int idx = pageId.lastIndexOf("-");
        String realWhiteboardId = idx == -1 ? pageId : pageId.substring(0, idx);
        RtcWhiteboard rtcWhiteboard = this.mEngine.getWhiteboardById(realWhiteboardId);
        return rtcWhiteboard != null ? rtcWhiteboard.getAttachedRtcWbView() : null;
    }

    private PanoCoursePageView getPanoCoursePageViewById(String pageId) {
        int idx = pageId.lastIndexOf("-");
        String realWhiteboardId = idx == -1 ? pageId : pageId.substring(0, idx);
        RtcWhiteboard rtcWhiteboard = this.mEngine.getWhiteboardById(realWhiteboardId);
        return rtcWhiteboard != null ? rtcWhiteboard.getAttachedCoursePageView() : null;
    }

    public void setOpaque(String wbId, boolean opaque) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(wbId);
        if (panoCoursePageView != null) {
            panoCoursePageView.setOpaque(opaque);
        }
    }

    public boolean getOpaque(String wbId) {
        RtcWbView wbView = this.getRtcWbViewById(wbId);
        if (wbView == null) {
            return false;
        }
        boolean transparent = wbView.isTransparent();
        return !transparent;
    }

    public void setLimitSize(String wbId, int w, int h) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(wbId);
        if (panoCoursePageView != null) {
            panoCoursePageView.setLimitSize(w, h);
        }
    }

    public void open(String pageId, String url) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.open(pageId, this.mNativeHandle, url);
        }
    }

    public void show(String pageId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.show(pageId);
        }
    }

    public void hide(String pageId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.hide(pageId);
        }
    }

    public void close(String pageId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.close(pageId);
        }
    }

    public void resize(String pageId, int width, int height) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.resize(pageId, width, height);
        }
    }

    public void evaluateJavaScript(String pageId, String javascript) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.evaluateJavaScript(pageId, javascript);
        }
    }

    public void scaleAtPoint(String pageId, float scale, float x, float y) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.scaleAtPoint(pageId, scale, x, y);
        }
    }

    public void move(String pageId, float dx, float dy) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.move(pageId, dx, dy);
        }
    }

    public void snapshot(String pageId, String filePath, boolean viewArea, int contentW, int contentH) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.snapShot(pageId, filePath, viewArea, contentW, contentH);
        }
    }

    public void refresh(String pageId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.refresh(pageId);
        }
    }

    public void setContentSize(String pageId, int width, int height) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(pageId);
        if (panoCoursePageView != null) {
            panoCoursePageView.setContentSize(pageId, width, height);
        }
    }

    public void openMedia(String shapeId, String url) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.openMedia(shapeId, this.mNativeHandle, url);
        }
    }

    public void closeMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.closeMedia(shapeId);
        }
    }

    public void stopMedia(String shapeId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.stopMedia(shapeId);
        }
    }

    public void updateRgn(String shapeId, float left, float top, float right, float bottom) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.updateMediaRgn(shapeId, left, top, right, bottom);
        }
    }

    public void updatePlayerStatus(String shapeId, boolean isPlay, float playTS, boolean isRepeat) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(shapeId);
        if (panoCoursePageView != null) {
            panoCoursePageView.updateMediaStatus(shapeId, isPlay, playTS, isRepeat);
        }
    }

    public void addCursor(String labelId, String name) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(labelId);
        if (panoCoursePageView != null) {
            panoCoursePageView.addCursor(labelId, name);
        }
    }

    public void removeCursor(String labelId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(labelId);
        if (panoCoursePageView != null) {
            panoCoursePageView.removeCursor(labelId);
        }
    }

    public void updateCursor(String labelId, float x, float y, int color, int type) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(labelId);
        if (panoCoursePageView != null) {
            panoCoursePageView.updateCursor(labelId, x, y, color, type);
        }
    }

    public void openPdf(String fileId, String url) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.openPdf(fileId, this.mNativeHandle, url);
        }
    }

    public void showPdf(String fileId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.showPdf(fileId);
        }
    }

    public void hidePdf(String fileId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.hidePdf(fileId);
        }
    }

    public void closePdf(String fileId) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.closePdf(fileId);
        }
    }

    public void scrollPdfTo(String fileId, int page, float pos) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.scrollPdfTo(fileId, page, pos);
        }
    }

    public void scalePdfTo(String fileId, float scale, float x, float y) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.scalePdfTo(fileId, scale, x, y);
        }
    }

    public void snapshotPdf(String fileId, String filePath) {
        PanoCoursePageView panoCoursePageView = this.getPanoCoursePageViewById(fileId);
        if (panoCoursePageView != null) {
            panoCoursePageView.snapshotPdf(fileId, filePath);
        }
    }

    public static native void onUrlChange(long var0, String var2, String var3);

    public static native void onSnapshotComplete(long var0, String var2, String var3);
}

