/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.RtcView;
import java.nio.ByteBuffer;
import video.pano.VideoFrame;
import video.pano.VideoSink;
import video.pano.YuvHelper;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.base.annotation.Keep;
import video.pano.rtc.video.ISnapShot;

public class ProxyVideoRender
implements IVideoRender {
    private static final String TAG = "ProxyVideoSink";
    private VideoSink target;
    private volatile ISnapShot snapShot;
    volatile boolean isSnapShot;
    private static final Object sinkLock = new Object();
    private IVideoRender.ScalingType mScaleType = IVideoRender.ScalingType.SCALE_ASPECT_FIT;
    private boolean mMirror = false;
    private boolean mDeviceMirror = false;

    @Override
    public void setScalingType(IVideoRender.ScalingType type) {
        this.mScaleType = type;
    }

    @Override
    public void setMirror(boolean mirror) {
        this.mMirror = mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceMirror(boolean mirror) {
        VideoSink sink;
        this.mDeviceMirror = mirror;
        Object object = sinkLock;
        synchronized (object) {
            sink = this.target;
        }
        if (sink != null) {
            sink.setDeviceMirror(this.mDeviceMirror);
        }
    }

    public void setScalingType(IVideoRender.ScalingType type, long nativeEngine, long userId, int streamId) {
        this.mScaleType = type;
        if (nativeEngine != 0L) {
            this.setScalingType(nativeEngine, userId, streamId, type.getValue());
        }
    }

    public void setMirror(boolean mirror, long nativeEngine, long userId, int streamId) {
        this.mMirror = mirror;
        if (nativeEngine != 0L) {
            this.setMirror(nativeEngine, userId, streamId, mirror);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScalingRatioWithFocus(float ratio, int x, int y) {
        VideoSink sink;
        Object object = sinkLock;
        synchronized (object) {
            sink = this.target;
        }
        if (sink instanceof RtcView) {
            ((RtcView)sink).setScalingRatioWithFocus(ratio, x, y);
        }
    }

    @Override
    public void setScalingRatio(IVideoRender.ScalingRatio ratio) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMovingDistance(int dx, int dy) {
        VideoSink sink;
        Object object = sinkLock;
        synchronized (object) {
            sink = this.target;
        }
        if (sink instanceof RtcView) {
            ((RtcView)sink).setMovingDistance(dx, dy);
        }
    }

    @Override
    public IVideoRender.ScalingType getScalingType() {
        return this.mScaleType;
    }

    @Override
    public boolean getMirror() {
        return this.mMirror;
    }

    public boolean getDeviceMirror() {
        return this.mDeviceMirror;
    }

    @Keep
    @CalledByNative
    public int getScalingTypeValue() {
        return this.mScaleType.getValue();
    }

    @Keep
    @CalledByNative
    public boolean getMirrorValue() {
        return this.mMirror;
    }

    @Keep
    @CalledByNative
    public boolean getDeviceMirrorValue() {
        return this.mDeviceMirror;
    }

    void setSnapShotCallback(ISnapShot iSnapShot) {
        this.snapShot = iSnapShot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onFrame(VideoFrame frame) {
        VideoSink sink;
        Object object = sinkLock;
        synchronized (object) {
            sink = this.target;
        }
        if (sink == null) {
            return;
        }
        if (this.isSnapShot && this.snapShot != null) {
            VideoFrame.Buffer buffer = frame.getBuffer();
            VideoFrame.I420Buffer i420Buffer = buffer.toI420();
            int width = buffer.getWidth();
            int height = buffer.getHeight();
            ByteBuffer nv21Buffer = ByteBuffer.allocateDirect(width * height * 3 / 2);
            YuvHelper.I420ToNV21((ByteBuffer)i420Buffer.getDataY(), (int)i420Buffer.getStrideY(), (ByteBuffer)i420Buffer.getDataU(), (int)i420Buffer.getStrideU(), (ByteBuffer)i420Buffer.getDataV(), (int)i420Buffer.getStrideV(), (ByteBuffer)nv21Buffer, (int)width, (int)height);
            i420Buffer.release();
            this.snapShot.onSnapShot(nv21Buffer, width, height, frame.getRotation());
            this.isSnapShot = false;
        }
        sink.onFrame(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setTarget(VideoSink target) {
        Object object = sinkLock;
        synchronized (object) {
            this.target = target;
        }
        if (target != null) {
            target.setDeviceMirror(this.mDeviceMirror);
        }
    }

    VideoSink getTarget() {
        return this.target;
    }

    private native void setScalingType(long var1, long var3, int var5, int var6);

    private native void setMirror(long var1, long var3, int var5, boolean var6);
}

