/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcAudioDeviceManager;
import video.pano.rtc.audio.AudioDeviceManager;
import video.pano.rtc.base.thread.ThreadUtils;
import video.pano.rtc.impl.GlobalRef;

public class RtcAudioDeviceMgrImpl
implements RtcAudioDeviceManager {
    private final long mNativeHandle;
    private final AudioDeviceManager mDeviceMgr;

    RtcAudioDeviceMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mDeviceMgr = AudioDeviceManager.create(GlobalRef.applicationContext);
    }

    void start(int defaultDevice, int audioMode) {
        ThreadUtils.runOnUiThread(() -> this.mDeviceMgr.start(defaultDevice, audioMode, false, new AudioDeviceManager.AudioManagerEvents(){

            @Override
            public void onAudioSelectedDeviceChanged(int device) {
            }
        }));
    }

    void stop() {
        ThreadUtils.runOnUiThread(this.mDeviceMgr::stop);
    }

    void releaseDeviceManager() {
        ThreadUtils.runOnUiThread(this.mDeviceMgr::stop);
    }

    @Override
    public Constants.QResult setLoudspeakerStatus(boolean onoff) {
        this.mDeviceMgr.setDefaultAudioDevice(onoff ? 0 : 2);
        return Constants.QResult.OK;
    }

    @Override
    public boolean isLoudspeakerOn() {
        return this.mDeviceMgr.getSelectedAudioDevice() == 0;
    }

    @Override
    public Constants.QResult setMicrophoneMuteStatus(boolean enabled) {
        int ret = this.setMicrophoneMuteStatus(this.mNativeHandle, enabled);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setRecordDeviceVolume(int volume) {
        return Constants.QResult.valueOf(this.setRecordDeviceVolume(this.mNativeHandle, volume));
    }

    @Override
    public int getRecordDeviceVolume() {
        return this.getRecordDeviceVolume(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setPlayoutDeviceVolume(int volume) {
        return Constants.QResult.valueOf(this.setPlayoutDeviceVolume(this.mNativeHandle, volume));
    }

    @Override
    public int getPlayoutDeviceVolume() {
        return this.getPlayoutDeviceVolume(this.mNativeHandle);
    }

    public Constants.QResult startAudioDeviceTest(String recordDeviceId, String playoutDeviceId) {
        return Constants.QResult.valueOf(this.startAudioDeviceTest(this.mNativeHandle, recordDeviceId, playoutDeviceId));
    }

    public Constants.QResult stopAudioDeviceTest() {
        return Constants.QResult.valueOf(this.stopAudioDeviceTest(this.mNativeHandle));
    }

    @Override
    public int getRecordingLevel() {
        return this.getRecordingLevel(this.mNativeHandle);
    }

    @Override
    public int getPlayoutLevel() {
        return this.getPlayoutLevel(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setPlayoutDevice(Constants.AudioDevice device) {
        int dev;
        switch (device) {
            case Speakerphone: {
                dev = 0;
                break;
            }
            case Earpiece: {
                dev = 2;
                break;
            }
            case WiredHeadset: {
                dev = 1;
                break;
            }
            case Bluetooth: {
                dev = 3;
                break;
            }
            default: {
                dev = -1;
            }
        }
        this.mDeviceMgr.selectAudioDevice(dev);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult enablePlayoutDeviceSelection(boolean enabled) {
        this.mDeviceMgr.enableAudioDeviceSelection(enabled);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult startAudioRecording() {
        return Constants.QResult.valueOf(this.startAudioRecording(this.mNativeHandle));
    }

    @Override
    public Constants.QResult stopAudioRecording() {
        return Constants.QResult.valueOf(this.stopAudioRecording(this.mNativeHandle));
    }

    @Override
    public Constants.QResult startAudioPlayback() {
        return Constants.QResult.valueOf(this.startAudioPlayback(this.mNativeHandle));
    }

    @Override
    public Constants.QResult stopAudioPlayback() {
        return Constants.QResult.valueOf(this.stopAudioPlayback(this.mNativeHandle));
    }

    @Override
    public Constants.QResult setPlayoutDataMuteStatus(boolean muted) {
        int ret = this.setPlayoutDataMuteStatus(this.mNativeHandle, muted);
        return Constants.QResult.valueOf(ret);
    }

    public void setAudioMode(int audioMode) {
        this.mDeviceMgr.setAudioMode(audioMode);
    }

    private native int setMicrophoneMuteStatus(long var1, boolean var3);

    private native int setRecordDeviceVolume(long var1, int var3);

    private native int getRecordDeviceVolume(long var1);

    private native int setPlayoutDeviceVolume(long var1, int var3);

    private native int getPlayoutDeviceVolume(long var1);

    private native int startAudioDeviceTest(long var1, String var3, String var4);

    private native int stopAudioDeviceTest(long var1);

    private native int getRecordingLevel(long var1);

    private native int getPlayoutLevel(long var1);

    private native int startAudioRecording(long var1);

    private native int stopAudioRecording(long var1);

    private native int startAudioPlayback(long var1);

    private native int stopAudioPlayback(long var1);

    private native int setPlayoutDataMuteStatus(long var1, boolean var3);
}

