/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcAudioMixingConfig;
import com.pano.rtc.api.RtcAudioMixingMgr;
import com.pano.rtc.impl.RtcAudioMixingConfigImpl;
import com.pano.rtc.impl.RtcAudioMixingMgrCallback;

public class RtcAudioMixingMgrImpl
implements RtcAudioMixingMgr,
RtcAudioMixingMgrCallback {
    private final long mNativeHandle;
    private RtcAudioMixingMgr.Callback mCallback;

    RtcAudioMixingMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public Constants.QResult setCallback(RtcAudioMixingMgr.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult createAudioMixingTask(long taskId, String filename) {
        return Constants.QResult.valueOf(this.createAudioMixingTask(this.mNativeHandle, taskId, filename));
    }

    @Override
    public Constants.QResult destroyAudioMixingTask(long taskId) {
        return Constants.QResult.valueOf(this.destroyAudioMixingTask(this.mNativeHandle, taskId));
    }

    @Override
    public Constants.QResult startAudioMixingTask(long taskId, RtcAudioMixingConfig config) {
        RtcAudioMixingConfigImpl jconfig = new RtcAudioMixingConfigImpl();
        jconfig.setEnablePublish(config.enablePublish);
        jconfig.setPublishVolume(config.publishVolume);
        jconfig.setEnableLoopback(config.enableLoopback);
        jconfig.setLoopbackVolume(config.loopbackVolume);
        jconfig.setCycle(config.cycle);
        jconfig.setReplaceMicrophone(config.replaceMicrophone);
        return Constants.QResult.valueOf(this.startAudioMixingTask(this.mNativeHandle, taskId, jconfig));
    }

    @Override
    public Constants.QResult updateAudioMixingTask(long taskId, RtcAudioMixingConfig config) {
        RtcAudioMixingConfigImpl jconfig = new RtcAudioMixingConfigImpl();
        jconfig.setEnablePublish(config.enablePublish);
        jconfig.setPublishVolume(config.publishVolume);
        jconfig.setEnableLoopback(config.enableLoopback);
        jconfig.setLoopbackVolume(config.loopbackVolume);
        jconfig.setCycle(config.cycle);
        jconfig.setReplaceMicrophone(config.replaceMicrophone);
        return Constants.QResult.valueOf(this.updateAudioMixingTask(this.mNativeHandle, taskId, jconfig));
    }

    @Override
    public Constants.QResult stopAudioMixingTask(long taskId) {
        return Constants.QResult.valueOf(this.stopAudioMixingTask(this.mNativeHandle, taskId));
    }

    @Override
    public Constants.QResult resumeAudioMixing(long taskId) {
        return Constants.QResult.valueOf(this.resumeAudioMixing(this.mNativeHandle, taskId));
    }

    @Override
    public Constants.QResult pauseAudioMixing(long taskId) {
        return Constants.QResult.valueOf(this.pauseAudioMixing(this.mNativeHandle, taskId));
    }

    @Override
    public long getAudioMixingDuration(long taskId) {
        return this.getAudioMixingDuration(this.mNativeHandle, taskId);
    }

    @Override
    public long getCurrentAudioMixingTimestamp(long taskId) {
        return this.getCurrentAudioMixingTimestamp(this.mNativeHandle, taskId);
    }

    @Override
    public Constants.QResult seekAudioMixing(long taskId, long timestampMs) {
        return Constants.QResult.valueOf(this.seekAudioMixing(this.mNativeHandle, taskId, timestampMs));
    }

    @Override
    public void onAudioMixingStateChanged(long taskId, Constants.AudioMixingState state) {
        if (this.mCallback != null) {
            this.mCallback.onAudioMixingStateChanged(taskId, state);
        }
    }

    private native int createAudioMixingTask(long var1, long var3, String var5);

    private native int destroyAudioMixingTask(long var1, long var3);

    private native int startAudioMixingTask(long var1, long var3, RtcAudioMixingConfigImpl var5);

    private native int updateAudioMixingTask(long var1, long var3, RtcAudioMixingConfigImpl var5);

    private native int stopAudioMixingTask(long var1, long var3);

    private native int resumeAudioMixing(long var1, long var3);

    private native int pauseAudioMixing(long var1, long var3);

    private native long getAudioMixingDuration(long var1, long var3);

    private native long getCurrentAudioMixingTimestamp(long var1, long var3);

    private native int seekAudioMixing(long var1, long var3, long var5);
}

