/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcGroupManager;
import video.pano.rtc.base.annotation.CalledByNative;

public class RtcGroupMgrImpl
implements RtcGroupManager {
    private final long mNativeHandle;
    private RtcGroupManager.Callback mCallback;

    RtcGroupMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public Constants.QResult setCallback(RtcGroupManager.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.valueOf(this.setCallback(this.mNativeHandle, this));
    }

    @Override
    public Constants.QResult joinGroup(String groupId, RtcGroupManager.GroupConfig config) {
        return Constants.QResult.valueOf(this.joinGroup(this.mNativeHandle, groupId, config.userData));
    }

    @Override
    public Constants.QResult subscribeGroup(String groupId) {
        return Constants.QResult.valueOf(this.subscribeGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult unsubscribeGroup(String groupId) {
        return Constants.QResult.valueOf(this.unsubscribeGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult leaveGroup(String groupId) {
        return Constants.QResult.valueOf(this.leaveGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult inviteGroupUsers(String groupId, long[] users) {
        return Constants.QResult.valueOf(this.inviteGroupUsers(this.mNativeHandle, groupId, users));
    }

    @Override
    public Constants.QResult dismissGroup(String groupId) {
        return Constants.QResult.valueOf(this.dismissGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult setDefaultGroup(String groupId) {
        return Constants.QResult.valueOf(this.setDefaultGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult observeGroup(String groupId) {
        return Constants.QResult.valueOf(this.observeGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult unobserveGroup(String groupId) {
        return Constants.QResult.valueOf(this.unobserveGroup(this.mNativeHandle, groupId));
    }

    @Override
    public Constants.QResult observeAllGroups() {
        return Constants.QResult.valueOf(this.observeAllGroups(this.mNativeHandle));
    }

    @Override
    public Constants.QResult unobserveAllGroups() {
        return Constants.QResult.valueOf(this.unobserveAllGroups(this.mNativeHandle));
    }

    @CalledByNative
    public void onGroupJoinConfirm(String groupId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onGroupJoinConfirm(groupId, Constants.QResult.valueOf(result));
        }
    }

    @CalledByNative
    public void onGroupLeaveIndication(String groupId, int reason) {
        if (this.mCallback != null) {
            this.mCallback.onGroupLeaveIndication(groupId, Constants.QResult.valueOf(reason));
        }
    }

    @CalledByNative
    public void onGroupInviteIndication(String groupId, long fromUserId) {
        if (this.mCallback != null) {
            this.mCallback.onGroupInviteIndication(groupId, fromUserId);
        }
    }

    @CalledByNative
    public void onGroupDismissConfirm(String groupId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onGroupDismissConfirm(groupId, Constants.QResult.valueOf(result));
        }
    }

    @CalledByNative
    public void onGroupUserJoinIndication(String groupId, long userId, String userData) {
        if (this.mCallback != null) {
            RtcGroupManager.UserInfo userInfo = new RtcGroupManager.UserInfo();
            userInfo.userId = userId;
            userInfo.userData = userData;
            this.mCallback.onGroupUserJoinIndication(groupId, userInfo);
        }
    }

    @CalledByNative
    public void onGroupUserLeaveIndication(String groupId, long userId, int reason) {
        if (this.mCallback != null) {
            this.mCallback.onGroupUserLeaveIndication(groupId, userId, Constants.QResult.valueOf(reason));
        }
    }

    @CalledByNative
    public void onGroupDefaultUpdateIndication(String groupId) {
        if (this.mCallback != null) {
            this.mCallback.onGroupDefaultUpdateIndication(groupId);
        }
    }

    @CalledByNative
    public void onGroupObserveConfirm(String groupId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onGroupObserveConfirm(groupId, Constants.QResult.valueOf(result));
        }
    }

    public native int setCallback(long var1, Object var3);

    public native int joinGroup(long var1, String var3, String var4);

    public native int subscribeGroup(long var1, String var3);

    public native int unsubscribeGroup(long var1, String var3);

    public native int leaveGroup(long var1, String var3);

    public native int inviteGroupUsers(long var1, String var3, long[] var4);

    public native int dismissGroup(long var1, String var3);

    public native int setDefaultGroup(long var1, String var3);

    public native int observeGroup(long var1, String var3);

    public native int unobserveGroup(long var1, String var3);

    public native int observeAllGroups(long var1);

    public native int unobserveAllGroups(long var1);
}

