/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RemoteControlView;
import com.pano.rtc.api.RtcRemoteController;
import com.pano.rtc.api.RtcView;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.PLogger;
import video.pano.rtc.remotecontrol.MouseCursor;
import video.pano.rtc.remotecontrol.RemoteControlGestureHandler;

class RtcRemoteControllerImpl
implements RtcRemoteController,
RemoteControlGestureHandler.Callback {
    private static final String TAG = "[pano]";
    private final long mNativeHandle;
    private RtcRemoteController.Callback mCallback;
    private final RemoteControlGestureHandler mGestureHandler;
    private long mRemoteUserId = -1L;
    private int mRemoteScreenWidth;
    private int mRemoteScreenHeight;
    private RtcView mRtcView;
    private RemoteControlView mRemoteControlView;
    private boolean mControlling = false;
    private final float mDensity;
    private float mCursorX;
    private float mCursorY;
    private int mCurrentCursorType;
    private final SparseArray<Bitmap> mCursorBitmapArray = new SparseArray();
    private final SparseIntArray mCursorHotspotXArray = new SparseIntArray();
    private final SparseIntArray mCursorHotspotYArray = new SparseIntArray();

    RtcRemoteControllerImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
        this.mGestureHandler = new RemoteControlGestureHandler(GlobalRef.applicationContext, this);
        this.mDensity = GlobalRef.applicationContext.getResources().getDisplayMetrics().density;
    }

    void onUserScreenResolutionChanged(long userId, int width, int height) {
        if (this.mRemoteUserId == 0L || this.mRemoteUserId == userId) {
            this.mRemoteScreenWidth = width;
            this.mRemoteScreenHeight = height;
        }
    }

    void setRemoteScreenView(RemoteControlView view) {
        this.mRemoteControlView = view;
        this.mRtcView = this.mRemoteControlView.getRtcView();
        if (this.mControlling) {
            this.mRtcView.setRtcTouchListener((v, event) -> this.mGestureHandler.handleEvent(event));
            this.mRemoteControlView.post(() -> {
                Bitmap bitmap = (Bitmap)this.mCursorBitmapArray.get(this.mCurrentCursorType);
                int hotspotX = this.mCursorHotspotXArray.get(this.mCurrentCursorType);
                int hotspotY = this.mCursorHotspotXArray.get(this.mCurrentCursorType);
                this.mRemoteControlView.onCursorChanged(bitmap, hotspotX, hotspotY);
            });
        }
    }

    @Override
    public Constants.QResult setCallback(RtcRemoteController.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.valueOf(this.setCallback(this.mNativeHandle, this));
    }

    @Override
    public Constants.QResult requestControl(long userId, boolean needElevation) {
        PLogger.i(TAG, "requestControl, userId : " + userId + ", elevate=" + needElevation);
        this.mRemoteUserId = userId;
        return Constants.QResult.valueOf(this.requestControl(this.mNativeHandle, userId, needElevation));
    }

    @Override
    public Constants.QResult acceptControl(long userId) {
        return Constants.QResult.valueOf(this.acceptControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult rejectControl(long userId) {
        return Constants.QResult.valueOf(this.rejectControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult setModifierFlags(long userId, int flags) {
        return Constants.QResult.valueOf(this.setModifierFlags(this.mNativeHandle, userId, flags));
    }

    @Override
    public Constants.QResult cancelControl(long userId) {
        this.cancelControl();
        return Constants.QResult.valueOf(this.cancelControl(this.mNativeHandle, userId));
    }

    @Override
    public Constants.QResult sendKeyboardEvent(long userId, int action, int keyCode) {
        return Constants.QResult.valueOf(this.sendKeyboardEvent(this.mNativeHandle, userId, action, keyCode));
    }

    @CalledByNative
    public void onRemoteControlRequest(long userId, boolean needElevation) {
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlRequest(userId, needElevation);
        }
    }

    @CalledByNative
    public void onRemoteControlResponse(long userId, int result) {
        PLogger.i(TAG, "onRemoteControlResponse, userId : " + userId + " result : " + result);
        if (this.mRemoteUserId == userId && result == Constants.QResult.OK.getValue()) {
            if (this.mRtcView != null) {
                this.mRtcView.setRtcTouchListener((v, event) -> this.mGestureHandler.handleEvent(event));
            }
            this.mControlling = true;
        }
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlResponse(userId, Constants.QResult.valueOf(result));
        }
    }

    @CalledByNative
    public void onRemoteControlCancelled(long userId, int reason) {
        PLogger.i(TAG, "onRemoteControlCancelled, userId : " + userId + " reason : " + reason);
        if (userId == this.mRemoteUserId) {
            this.cancelControl();
        }
        if (this.mCallback != null) {
            this.mCallback.onRemoteControlCancelled(userId, Constants.QResult.valueOf(reason));
        }
    }

    @CalledByNative
    public void onRemoteControlMouseCursor(long userId, MouseCursor cursor) {
        this.mCurrentCursorType = cursor.type;
        Bitmap bitmap = (Bitmap)this.mCursorBitmapArray.get(cursor.type);
        if (bitmap != null) {
            int hotspotX = this.mCursorHotspotXArray.get(cursor.type);
            int hotspotY = this.mCursorHotspotYArray.get(cursor.type);
            this.mRemoteControlView.onCursorChanged(bitmap, hotspotX, hotspotY);
            return;
        }
        MouseCursor.IconData iconData = cursor.getIconData();
        if (iconData == null || iconData.data == null || iconData.data.length == 0) {
            return;
        }
        try {
            bitmap = Bitmap.createBitmap((int)iconData.width, (int)iconData.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            ByteBuffer buffer = ByteBuffer.wrap(iconData.data);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            float scale = this.mDensity * iconData.targetScale / iconData.sizeScale;
            if (scale != 1.0f) {
                Matrix matrix = new Matrix();
                matrix.postScale(scale, scale);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            }
            this.mCursorBitmapArray.put(cursor.type, (Object)bitmap);
            int hotspotX = Math.round((float)cursor.hotspotx * this.mDensity * iconData.targetScale);
            int hotspotY = Math.round((float)cursor.hotspoty * this.mDensity * iconData.targetScale);
            this.mCursorHotspotXArray.put(cursor.type, hotspotX);
            this.mCursorHotspotYArray.put(cursor.type, hotspotY);
            this.mRemoteControlView.onCursorChanged(bitmap, hotspotX, hotspotY);
        }
        catch (Exception e) {
            PLogger.e(TAG, "Create cursor bitmap error : " + e.getMessage());
        }
    }

    @Override
    public void onBegin(float x, float y) {
    }

    @Override
    public void onClicked(float x, float y) {
        this.sendMouseEvent(1, 1);
    }

    @Override
    public void onRightClicked(float x, float y) {
        this.sendMouseEvent(1, 2);
    }

    @Override
    public void onDoubleClicked(float x, float y) {
        this.sendMouseEvent(2, 1);
    }

    @Override
    public void onMove(float x, float y, float dx, float dy, float vx, float vy) {
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        if (!this.calculateCoordinate(dx, dy)) {
            return;
        }
        this.mRemoteControlView.onMouseMove(this.mCursorX, this.mCursorY);
        this.sendMouseEvent(4, 0);
    }

    @Override
    public void onDrag(float x, float y, float dx, float dy, float vx, float vy) {
        if (!this.calculateCoordinate(dx, dy)) {
            return;
        }
        this.mRemoteControlView.onMouseMove(this.mCursorX, this.mCursorY);
        this.sendMouseEvent(7, 1);
    }

    @Override
    public void onScroll(float x, float y, float dx, float dy, float vx, float vy) {
        this.sendDeltaMouseEvent(this.mNativeHandle, this.mRemoteUserId, 5, 4, dx, dy);
    }

    @Override
    public void onScale(float factor, float focusX, float focusY, float spanX, float spanY) {
        this.mRtcView.setScalingRatioWithFocus(factor, (int)focusX, (int)focusY);
        this.mRtcView.redrawFrame();
        this.calculateCoordinate(0.0f, 0.0f);
        this.mRemoteControlView.onMouseMove(this.mCursorX, this.mCursorY);
    }

    @Override
    public void onEnd(float x, float y) {
        this.sendMouseEvent(15, 0);
    }

    @Override
    public void onCancel() {
    }

    private void cancelControl() {
        this.mControlling = false;
        this.mCursorBitmapArray.clear();
        this.mCursorHotspotXArray.clear();
        this.mCursorHotspotYArray.clear();
        if (this.mRtcView != null) {
            this.mRtcView.setRtcTouchListener(null);
            this.mRtcView = null;
        }
        this.mRemoteUserId = -1L;
    }

    private boolean calculateCoordinate(float dx, float dy) {
        int viewPortWidth = this.mRtcView.getViewPortWidth();
        int viewPortHeight = this.mRtcView.getViewPortHeight();
        if (viewPortWidth == 0 || viewPortHeight == 0) {
            return false;
        }
        float offsetX = (float)viewPortWidth * this.mCursorX + dx;
        float offsetY = (float)viewPortHeight * this.mCursorY + dy;
        if (offsetX < 0.0f) {
            offsetX = 0.0f;
        } else if (offsetX > (float)viewPortWidth) {
            offsetX = viewPortWidth;
        }
        if (offsetY < 0.0f) {
            offsetY = 0.0f;
        } else if (offsetY > (float)viewPortHeight) {
            offsetY = viewPortHeight;
        }
        this.mCursorX = offsetX / (float)viewPortWidth;
        this.mCursorY = offsetY / (float)viewPortHeight;
        return true;
    }

    private void sendMouseEvent(int type, int mouseButton) {
        this.sendMouseEvent(this.mNativeHandle, this.mRemoteUserId, type, mouseButton, this.mCursorX, this.mCursorY);
    }

    private native int setCallback(long var1, Object var3);

    private native int requestControl(long var1, long var3, boolean var5);

    private native int acceptControl(long var1, long var3);

    private native int rejectControl(long var1, long var3);

    private native int cancelControl(long var1, long var3);

    private native int setModifierFlags(long var1, long var3, int var5);

    private native int sendMouseEvent(long var1, long var3, int var5, int var6, float var7, float var8);

    private native int sendDeltaMouseEvent(long var1, long var3, int var5, int var6, float var7, float var8);

    private native int sendKeyboardEvent(long var1, long var3, int var5, int var6);
}

