/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.text.TextUtils;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcVideoDeviceManager;
import com.pano.rtc.api.model.RtcDeviceInfo;
import com.pano.rtc.impl.CameraControllerImpl;
import com.pano.rtc.impl.RtcVideoStreamMgrImpl;
import java.util.HashMap;
import video.pano.CustomizedOrientation;
import video.pano.VideoSink;

public class RtcVideoDeviceMgrImpl
implements RtcVideoDeviceManager {
    private final long mNativeHandle;
    private final HashMap<String, CameraControllerImpl> mCameraControllerMap = new HashMap();

    RtcVideoDeviceMgrImpl(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    @Override
    public RtcDeviceInfo[] getCaptureDeviceList() {
        return this.getCaptureDeviceList(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setDeviceOrientation(String deviceId, Integer orientation) {
        String cameraId = RtcVideoStreamMgrImpl.getCameraId(deviceId);
        if (!RtcVideoStreamMgrImpl.verifyCameraId(cameraId)) {
            return Constants.QResult.InvalidArgs;
        }
        int camId = -1;
        try {
            camId = Integer.parseInt(cameraId);
        }
        catch (NumberFormatException e) {
            return Constants.QResult.InvalidArgs;
        }
        return this.setDeviceOrientation(camId, orientation);
    }

    public Constants.QResult setDeviceOrientation(int cameraId, Integer orientation) {
        CustomizedOrientation.setDeviceOrientation((int)cameraId, (Integer)orientation);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setMirrorCorrection(boolean correction) {
        CustomizedOrientation.setMirrorCorrection((boolean)correction);
        return Constants.QResult.OK;
    }

    @Override
    public RtcVideoDeviceManager.CameraController getCameraController(String deviceId) {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            throw new IllegalArgumentException("Camera deviceId should not be null!");
        }
        CameraControllerImpl controller = this.mCameraControllerMap.get(deviceId);
        if (controller == null) {
            controller = new CameraControllerImpl(this.mNativeHandle, deviceId);
            this.mCameraControllerMap.put(deviceId, controller);
        }
        return controller;
    }

    void releaseDeviceManager() {
        this.mCameraControllerMap.clear();
    }

    void setPreviewRender(String deviceId, VideoSink render) {
        CameraControllerImpl controller = (CameraControllerImpl)this.getCameraController(deviceId);
        controller.setPreviewRender(render);
    }

    private native RtcDeviceInfo[] getCaptureDeviceList(long var1);
}

