/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import com.pano.coco.impl.CocoNativeCapturerObserver;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcVideoTextureFilter;
import com.pano.rtc.api.RtcVideoTextureFilterConfig;
import com.pano.rtc.api.model.BuiltinTransformParams;
import com.pano.rtc.api.model.FaceBeautifyParams;
import com.pano.rtc.api.model.QuadTransformParams;
import com.pano.rtc.api.model.VideoBrightnessParams;
import com.pano.rtc.video.RtcCaptureObserver;
import java.util.HashMap;
import java.util.Map;
import video.pano.EglBase;
import video.pano.rtc.impl.PLogger;

public class RtcVideoFilterMgrImpl {
    private static final String TAG = "RtcVideoFilterMgrImpl";
    private EglBase.Context eglSharedContext;
    private Map<String, RtcCaptureObserver> filterMap = new HashMap<String, RtcCaptureObserver>();
    private final Object filterMapLock = new Object();

    RtcVideoFilterMgrImpl(EglBase.Context eglContext) {
        this.eglSharedContext = eglContext;
    }

    private RtcCaptureObserver getTargetObserver(String target, boolean add) {
        if (target == null || target.isEmpty()) {
            PLogger.ne(TAG, "RtcVideoFilterMgrImpl.getTargetObserver, unable to get target device id");
            return null;
        }
        RtcCaptureObserver observer = this.filterMap.get(target);
        if (observer == null) {
            if (add) {
                PLogger.ni(TAG, "Creating observer for device: " + target);
                RtcCaptureObserver newObserver = new RtcCaptureObserver(this.eglSharedContext);
                CocoNativeCapturerObserver.setFilter(newObserver.cocoCaptureFrameObserver, target);
                this.filterMap.put(target, newObserver);
                return this.filterMap.get(target);
            }
            return null;
        }
        return observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setFaceBeautify(FaceBeautifyParams param, String deviceId, boolean dynamic) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.setFaceBeautify(param, dynamic);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setFaceBeautifyEnable(boolean enable, String deviceId) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.setFaceBeautifyEnable(enable);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult updateFaceBeautifyIntensity(float intensity, String deviceId) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.updateFaceBeautifyIntensity(intensity);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setBuiltinTransform(BuiltinTransformParams param, String deviceId, boolean dynamic) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.setBuiltinTransform(param, dynamic);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setQuadTransform(QuadTransformParams param, String deviceId, boolean dynamic) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.setQuadTransform(param, dynamic);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setVideoBrightness(VideoBrightnessParams param, String deviceId, boolean dynamic) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, true);
            if (observer != null) {
                return observer.setVideoBrightness(param, dynamic);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Constants.QResult setLocalVideoFilter(RtcVideoTextureFilter filter, RtcVideoTextureFilterConfig config, String deviceId, boolean dynamic) {
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver observer;
            if (filter != null && deviceId != null) {
                for (Map.Entry<String, RtcCaptureObserver> entry : this.filterMap.entrySet()) {
                    if (entry.getValue().externalFilter != filter || entry.getKey().equals(deviceId)) continue;
                    PLogger.e(TAG, "Set same external filter to multiple devices is not allowed");
                    return Constants.QResult.InvalidArgs;
                }
            }
            if ((observer = this.getTargetObserver(deviceId, true)) != null) {
                return observer.setLocalVideoFilter(filter, config, dynamic, true);
            }
            return Constants.QResult.Failed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void transFilterParamIfDynamic(String srcDeviceId, String dstDeviceId) {
        PLogger.ni(TAG, "Trying to transfer filter param from " + srcDeviceId + " to " + dstDeviceId);
        if (srcDeviceId == null || dstDeviceId == null || srcDeviceId.equals(dstDeviceId)) {
            return;
        }
        Object object = this.filterMapLock;
        synchronized (object) {
            RtcCaptureObserver srcObserver = this.getTargetObserver(srcDeviceId, false);
            if (srcObserver == null) {
                return;
            }
            RtcCaptureObserver dstObserver = this.getTargetObserver(dstDeviceId, true);
            if (dstObserver == null) {
                PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, failed to find dst observer");
                return;
            }
            dstObserver.faceBeautifyTransferred = false;
            srcObserver.faceBeautifyTransferred = false;
            if (srcObserver.faceBeautifyDynamic) {
                if (!dstObserver.faceBeautifyParams.enable) {
                    dstObserver.setFaceBeautify(srcObserver.faceBeautifyParams, true);
                    dstObserver.faceBeautifyTransferred = true;
                    srcObserver.faceBeautifyTransferred = true;
                } else {
                    PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, target face beautify is enabled");
                }
            }
            dstObserver.builtinTransformTransferred = false;
            srcObserver.builtinTransformTransferred = false;
            if (srcObserver.builtinTransformDynamic) {
                if (!dstObserver.builtinTransformParams.enable) {
                    dstObserver.setBuiltinTransform(srcObserver.builtinTransformParams, true);
                    dstObserver.cocoCaptureFrameObserver.setTotalBuiltinTransformParam(srcObserver.cocoCaptureFrameObserver.getTotalBuiltinTransformParam());
                    dstObserver.builtinTransformTransferred = true;
                    srcObserver.builtinTransformTransferred = true;
                } else {
                    PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, target builtin transform is enabled");
                }
            }
            dstObserver.quadTransformTransferred = false;
            srcObserver.quadTransformTransferred = false;
            if (srcObserver.quadTransformDynamic) {
                if (!dstObserver.quadTransformParams.enable) {
                    dstObserver.setQuadTransform(srcObserver.quadTransformParams, true);
                    dstObserver.cocoCaptureFrameObserver.setTotalQuadTransformParam(srcObserver.cocoCaptureFrameObserver.getTotalQuadTransformParam());
                    dstObserver.quadTransformTransferred = true;
                    srcObserver.quadTransformTransferred = true;
                } else {
                    PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, target quad transform is enabled");
                }
            }
            dstObserver.brightnessTransferred = false;
            srcObserver.brightnessTransferred = false;
            if (srcObserver.brightnessDynamic) {
                if (!dstObserver.videoBrightnessParams.enable) {
                    dstObserver.setVideoBrightness(srcObserver.videoBrightnessParams, true);
                    dstObserver.brightnessTransferred = true;
                    srcObserver.brightnessTransferred = true;
                } else {
                    PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, target brightness is enabled");
                }
            }
            dstObserver.externalFilterTransferred = false;
            srcObserver.externalFilterTransferred = false;
            if (srcObserver.externalFilterDynamic) {
                if (dstObserver.externalFilter == null) {
                    dstObserver.setLocalVideoFilter(srcObserver.externalFilter, srcObserver.externalFilterConfig, true, true);
                    dstObserver.externalFilterTransferred = true;
                    srcObserver.externalFilterTransferred = true;
                } else {
                    PLogger.ne(TAG, "RtcVideoFilterMgrImpl.transFilterParamIfDynamic, target external filter is set");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeFilterIfDynamic(String deviceId) {
        PLogger.ni(TAG, "Trying to close filter of " + deviceId);
        Object object = this.filterMapLock;
        synchronized (object) {
            Object close;
            RtcCaptureObserver observer = this.getTargetObserver(deviceId, false);
            if (observer == null) {
                return;
            }
            if (observer.faceBeautifyDynamic && observer.faceBeautifyTransferred && observer.faceBeautifyParams.enable) {
                close = new FaceBeautifyParams();
                ((FaceBeautifyParams)close).enable = false;
                observer.setFaceBeautify((FaceBeautifyParams)close, false);
            }
            if (observer.builtinTransformDynamic && observer.builtinTransformTransferred && observer.builtinTransformParams.enable) {
                close = new BuiltinTransformParams();
                ((BuiltinTransformParams)close).enable = false;
                observer.setBuiltinTransform((BuiltinTransformParams)close, false);
            }
            if (observer.quadTransformDynamic && observer.quadTransformTransferred && observer.quadTransformParams.enable) {
                close = new QuadTransformParams();
                ((QuadTransformParams)close).enable = false;
                observer.setQuadTransform((QuadTransformParams)close, false);
            }
            if (observer.brightnessDynamic && observer.brightnessTransferred && observer.videoBrightnessParams.enable) {
                close = new VideoBrightnessParams();
                ((VideoBrightnessParams)close).enable = false;
                observer.setVideoBrightness((VideoBrightnessParams)close, false);
            }
            if (observer.externalFilterDynamic && observer.externalFilterTransferred && observer.externalFilter != null) {
                RtcVideoTextureFilterConfig config = new RtcVideoTextureFilterConfig();
                observer.setLocalVideoFilter(null, config, false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.filterMapLock;
        synchronized (object) {
            for (Map.Entry<String, RtcCaptureObserver> entry : this.filterMap.entrySet()) {
                CocoNativeCapturerObserver.setFilter(null, entry.getKey());
                entry.getValue().release();
            }
            this.filterMap.clear();
        }
    }
}

