/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.hardware.camera2.CameraManager;
import android.os.Build;
import android.os.Bundle;
import android.util.SparseArray;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.IVideoRender;
import com.pano.rtc.api.RtcSnapshotVideoOption;
import com.pano.rtc.api.RtcVideoStreamManager;
import com.pano.rtc.api.model.BuiltinTransformParams;
import com.pano.rtc.api.model.FaceBeautifyParams;
import com.pano.rtc.api.model.QuadTransformParams;
import com.pano.rtc.api.model.VideoBrightnessParams;
import com.pano.rtc.impl.ProxyVideoRender;
import com.pano.rtc.impl.RtcEngineImpl;
import com.pano.rtc.impl.RtcVideoFilterMgrImpl;
import com.pano.rtc.impl.RtcVideoStreamMgrCallback;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import video.pano.rtc.base.thread.ThreadUtils;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.PLogger;

public class RtcVideoStreamMgrImpl
implements RtcVideoStreamManager,
RtcVideoStreamMgrCallback {
    private static final String TAG = "[pano]";
    private final long mNativeHandle;
    private final RtcVideoFilterMgrImpl mRtcVideoFilterMgrImpl;
    private RtcVideoStreamManager.Callback mCallback;
    private final SparseArray<ProxyVideoRender> mLocalVideoRenders = new SparseArray();
    private final HashMap<String, ProxyVideoRender> mRemoteVideoRenders = new HashMap();
    private final SparseArray<StreamInfo> mStreamList = new SparseArray();
    private Object mCameraCallback;
    private Application.ActivityLifecycleCallbacks mAppLifecycleCallback;
    private boolean mIsAppInBackground = false;
    private final boolean[] mCameraStates = new boolean[]{true, true, true, true, true, true, true, true, true, true};
    private boolean mFailoverFlag = false;

    RtcVideoStreamMgrImpl(long nativeHandle, RtcVideoFilterMgrImpl filterMgr) {
        this.mNativeHandle = nativeHandle;
        this.mRtcVideoFilterMgrImpl = filterMgr;
    }

    @Override
    public Constants.QResult setCallback(RtcVideoStreamManager.Callback callback) {
        this.mCallback = callback;
        return Constants.QResult.valueOf(this.setCallback(this.mNativeHandle, this));
    }

    @Override
    public int createVideoStream(String deviceId) {
        int streamId = this.createVideoStream(this.mNativeHandle, deviceId);
        if (streamId >= 0) {
            StreamInfo stream = new StreamInfo();
            stream.streamId = streamId;
            stream.deviceId = deviceId;
            stream.cameraId = RtcVideoStreamMgrImpl.getCameraId(deviceId);
        }
        return streamId;
    }

    @Override
    public Constants.QResult destroyVideoStream(int streamId) {
        StreamInfo stream = this.getStream(streamId);
        Constants.QResult ret = Constants.QResult.valueOf(this.destroyVideoStream(this.mNativeHandle, streamId));
        this.removeStream(streamId);
        return ret;
    }

    @Override
    public Constants.QResult setCaptureDevice(int streamId, String deviceId) {
        boolean needTransFilterParam;
        String oldDeviceId = this.getCaptureDevice(streamId);
        boolean bl = needTransFilterParam = !oldDeviceId.isEmpty() && !deviceId.isEmpty() && !deviceId.equals(oldDeviceId);
        if (needTransFilterParam) {
            this.mRtcVideoFilterMgrImpl.transFilterParamIfDynamic(oldDeviceId, deviceId);
        }
        Constants.QResult ret = Constants.QResult.valueOf(this.setCaptureDevice(this.mNativeHandle, streamId, deviceId));
        StreamInfo stream = this.getStream(streamId);
        if (stream != null && ret == Constants.QResult.OK) {
            this.mRtcVideoFilterMgrImpl.transFilterParamIfDynamic(stream.deviceId, deviceId);
            stream.deviceId = deviceId;
            stream.cameraId = RtcVideoStreamMgrImpl.getCameraId(deviceId);
        }
        if (needTransFilterParam) {
            this.mRtcVideoFilterMgrImpl.closeFilterIfDynamic(ret == Constants.QResult.OK ? oldDeviceId : deviceId);
        }
        return ret;
    }

    @Override
    public String getCaptureDevice(int streamId) {
        return this.getCaptureDevice(this.mNativeHandle, streamId);
    }

    @Override
    public Constants.QResult setLocalVideoRender(int streamId, IVideoRender render) {
        PLogger.i(TAG, "VideoStreamMgr.setLocalVideoRender, streamId=" + streamId + ", render=" + render);
        this.targetLocalProxyRender(streamId, render);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRemoteVideoRender(long userId, int streamId, IVideoRender render) {
        PLogger.i(TAG, "VideoStreamMgr.setRemoteVideoRender, userId=" + userId + ", streamId=" + streamId + ", render=" + render);
        this.targetRemoteProxyRender(userId, streamId, render);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult startVideo(int streamId, Constants.VideoProfileType profileType) {
        Constants.QResult ret;
        ProxyVideoRender render = this.getLocalProxyRender(streamId);
        if (render != null && !ThreadUtils.runningOnUiThread()) {
            PLogger.w(TAG, "VideoStreamMgr.startVideo, not on main thread");
        }
        if ((ret = Constants.QResult.valueOf(this.startVideo(this.mNativeHandle, streamId, render, profileType.getValue()))) == Constants.QResult.OK) {
            this.onLocalVideoStreamStarted(streamId, profileType);
        }
        return ret;
    }

    @Override
    public Constants.QResult stopVideo(int streamId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.stopVideo(this.mNativeHandle, streamId));
        this.removeLocalProxyRender(streamId);
        this.onLocalVideoStreamStopped(streamId);
        return ret;
    }

    @Override
    public Constants.QResult muteVideo(int streamId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.muteVideo(this.mNativeHandle, streamId));
        if (ret == Constants.QResult.OK) {
            this.onLocalVideoStreamMuteState(streamId, true);
        }
        return ret;
    }

    @Override
    public Constants.QResult unmuteVideo(int streamId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.unmuteVideo(this.mNativeHandle, streamId));
        this.onLocalVideoStreamMuteState(streamId, false);
        return ret;
    }

    @Override
    public Constants.QResult subscribeVideo(long userId, int streamId, Constants.VideoProfileType profile) {
        ProxyVideoRender proxyVideoRender = this.getRemoteProxyRender(userId, streamId);
        if (proxyVideoRender != null && !ThreadUtils.runningOnUiThread()) {
            PLogger.w(TAG, "VideoStreamMgr.subscribeVideo, not on main thread, userId=" + userId + ", streamId=" + streamId);
        }
        return Constants.QResult.valueOf(this.subscribeVideo(this.mNativeHandle, userId, streamId, proxyVideoRender, profile.getValue()));
    }

    @Override
    public Constants.QResult unsubscribeVideo(long userId, int streamId) {
        Constants.QResult ret = Constants.QResult.valueOf(this.unsubscribeVideo(this.mNativeHandle, userId, streamId));
        this.removeRemoteProxyRender(userId, streamId);
        return ret;
    }

    @Override
    public Constants.QResult snapshotVideo(long userId, int streamId, String outputDir, RtcSnapshotVideoOption option) {
        return Constants.QResult.valueOf(this.snapshotVideo(this.mNativeHandle, userId, streamId, outputDir, option.format.getValue(), option.mirror));
    }

    @Override
    public Constants.QResult setOption(int streamId, Constants.PanoOptionType type, Object value) {
        StreamInfo stream = this.getStream(streamId);
        if (stream == null) {
            return Constants.QResult.NotExist;
        }
        switch (type) {
            case FaceBeautify: {
                if (!(value instanceof FaceBeautifyParams)) break;
                FaceBeautifyParams params = (FaceBeautifyParams)value;
                return this.mRtcVideoFilterMgrImpl.setFaceBeautify(params, stream.deviceId, true);
            }
            case PanoOptionBuiltinTransform: {
                if (!(value instanceof BuiltinTransformParams)) break;
                BuiltinTransformParams params = (BuiltinTransformParams)value;
                return this.mRtcVideoFilterMgrImpl.setBuiltinTransform(params, stream.deviceId, true);
            }
            case VideoQuadTransform: {
                if (!(value instanceof QuadTransformParams)) break;
                QuadTransformParams quadT = (QuadTransformParams)value;
                return this.mRtcVideoFilterMgrImpl.setQuadTransform(quadT, stream.deviceId, true);
            }
            case VideoBrightnessAdjuster: {
                if (!(value instanceof VideoBrightnessParams)) break;
                VideoBrightnessParams brightParam = (VideoBrightnessParams)value;
                return this.mRtcVideoFilterMgrImpl.setVideoBrightness(brightParam, stream.deviceId, true);
            }
            default: {
                return Constants.QResult.NotImplemented;
            }
        }
        return Constants.QResult.InvalidArgs;
    }

    ProxyVideoRender createProxyRender() {
        ProxyVideoRender proxyVideoRender = new ProxyVideoRender();
        proxyVideoRender.setSnapShotCallback((NV21Buffer, width, height, rotation) -> new Thread(() -> {
            try {
                YuvImage yuvImage = new YuvImage(NV21Buffer.array(), 17, width, height, null);
                ByteArrayOutputStream os = new ByteArrayOutputStream(NV21Buffer.array().length);
                if (!yuvImage.compressToJpeg(new Rect(0, 0, width, height), 100, (OutputStream)os)) {
                    PLogger.e(TAG, "yuvImage.compressToJpeg failed !");
                    return;
                }
                byte[] tmp = os.toByteArray();
                os.close();
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])tmp, (int)0, (int)tmp.length);
                if (rotation != 0) {
                    Matrix matrix = new Matrix();
                    matrix.setRotate((float)rotation);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)false);
                }
                if (this.mCallback == null) return;
            }
            catch (Exception e) {
                PLogger.e(TAG, "create snapshot bitmap failed: " + e.getMessage());
            }
        }).start());
        return proxyVideoRender;
    }

    ProxyVideoRender getLocalProxyRender(int streamId) {
        ProxyVideoRender proxyVideoRender = (ProxyVideoRender)this.mLocalVideoRenders.get(streamId);
        if (proxyVideoRender == null) {
            proxyVideoRender = this.createProxyRender();
            this.mLocalVideoRenders.put(streamId, (Object)proxyVideoRender);
        }
        return proxyVideoRender;
    }

    void removeLocalProxyRender(int streamId) {
        ProxyVideoRender proxyVideoRender = (ProxyVideoRender)this.mLocalVideoRenders.get(streamId);
        if (proxyVideoRender != null) {
            proxyVideoRender.setTarget(null);
            proxyVideoRender.setSnapShotCallback(null);
            this.mLocalVideoRenders.remove(streamId);
        }
    }

    void removeAllLocalProxyRenders() {
        int len = this.mLocalVideoRenders.size();
        for (int i = 0; i < len; ++i) {
            ProxyVideoRender proxyVideoRender = (ProxyVideoRender)this.mLocalVideoRenders.valueAt(i);
            proxyVideoRender.setTarget(null);
            proxyVideoRender.setSnapShotCallback(null);
        }
        this.mLocalVideoRenders.clear();
    }

    private void targetLocalProxyRender(int streamId, IVideoRender render) {
        ProxyVideoRender proxyVideoRender = this.getLocalProxyRender(streamId);
        proxyVideoRender.setTarget(render);
        if (render != null) {
            proxyVideoRender.setScalingType(render.getScalingType(), this.mNativeHandle, 0L, streamId);
            proxyVideoRender.setMirror(render.getMirror(), this.mNativeHandle, 0L, streamId);
        }
    }

    ProxyVideoRender getRemoteProxyRender(long userId, int streamId) {
        String key = "" + userId + "-" + streamId;
        ProxyVideoRender proxyVideoRender = this.mRemoteVideoRenders.get(key);
        if (proxyVideoRender == null) {
            proxyVideoRender = this.createProxyRender();
            this.mRemoteVideoRenders.put(key, proxyVideoRender);
        }
        return proxyVideoRender;
    }

    void removeRemoteProxyRender(long userId, int streamId) {
        String key = "" + userId + "-" + streamId;
        ProxyVideoRender proxyVideoRender = this.mRemoteVideoRenders.get(key);
        if (proxyVideoRender != null) {
            proxyVideoRender.setTarget(null);
            proxyVideoRender.setSnapShotCallback(null);
            this.mRemoteVideoRenders.remove(key);
        }
    }

    void removeAllRemoteProxyRenders() {
        for (Map.Entry<String, ProxyVideoRender> entry : this.mRemoteVideoRenders.entrySet()) {
            ProxyVideoRender proxyVideoRender = entry.getValue();
            proxyVideoRender.setTarget(null);
            proxyVideoRender.setSnapShotCallback(null);
        }
        this.mRemoteVideoRenders.clear();
    }

    private void targetRemoteProxyRender(long userId, int streamId, IVideoRender render) {
        ProxyVideoRender proxyVideoRender = this.getRemoteProxyRender(userId, streamId);
        proxyVideoRender.setTarget(render);
        if (render != null) {
            proxyVideoRender.setScalingType(render.getScalingType(), this.mNativeHandle, userId, streamId);
            proxyVideoRender.setMirror(render.getMirror(), this.mNativeHandle, userId, streamId);
        }
    }

    public Constants.QResult takeLocalSnapshot(int streamId) {
        ProxyVideoRender proxyVideoRender = this.getLocalProxyRender(streamId);
        if (proxyVideoRender != null) {
            PLogger.i(TAG, "takeLocalSnapshot: " + streamId);
            proxyVideoRender.isSnapShot = true;
            return Constants.QResult.OK;
        }
        PLogger.w(TAG, "takeLocalSnapshot: " + streamId + " failed, not startPreview or startVideo");
        return Constants.QResult.NotFound;
    }

    public Constants.QResult takeRemoteSnapshot(long userId, int streamId) {
        ProxyVideoRender proxyVideoRender = this.getRemoteProxyRender(userId, streamId);
        if (proxyVideoRender != null) {
            PLogger.i(TAG, "takeRemoteSnapshot: " + userId + "-" + streamId);
            proxyVideoRender.isSnapShot = true;
            return Constants.QResult.OK;
        }
        PLogger.w(TAG, "takeRemoteSnapshot: " + userId + "-" + streamId + " failed");
        return Constants.QResult.NotFound;
    }

    private void registerCameraCallback() {
        if (Build.VERSION.SDK_INT >= 21) {
            Arrays.fill(this.mCameraStates, true);
            if (this.mCameraCallback != null) {
                this.unregisterCameraCallback();
            }
            CameraManager manager = (CameraManager)GlobalRef.applicationContext.getSystemService("camera");
            this.mCameraCallback = new CameraManager.AvailabilityCallback(){

                public void onCameraAvailable(String cameraId) {
                    StreamInfo stream;
                    super.onCameraAvailable(cameraId);
                    PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- camera off id=" + cameraId + " -----");
                    int nCamId = Integer.parseInt(cameraId);
                    if (nCamId >= 0 && nCamId < RtcVideoStreamMgrImpl.this.mCameraStates.length) {
                        ((RtcVideoStreamMgrImpl)RtcVideoStreamMgrImpl.this).mCameraStates[nCamId] = true;
                    }
                    if ((stream = RtcVideoStreamMgrImpl.this.getActiveStream(cameraId)) != null) {
                        PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- video stream: " + stream.streamId + ", started=" + stream.started + ", restart=" + stream.restartFlag + ", background=" + RtcVideoStreamMgrImpl.this.mIsAppInBackground + " -----");
                        if (RtcVideoStreamMgrImpl.this.mIsAppInBackground) {
                            PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- stop video stream: " + stream.streamId + " -----");
                            stream.restartFlag = true;
                            RtcVideoStreamMgrImpl.this.stopVideo(RtcVideoStreamMgrImpl.this.mNativeHandle, stream.streamId);
                        } else if (stream.started && stream.restartFlag) {
                            RtcVideoStreamMgrImpl.this.recoverLocalVideoStream(stream);
                        }
                    }
                }

                public void onCameraUnavailable(String cameraId) {
                    super.onCameraUnavailable(cameraId);
                    PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- camera on id=" + cameraId + " -----");
                    int nCamId = Integer.parseInt(cameraId);
                    if (nCamId >= 0 && nCamId < RtcVideoStreamMgrImpl.this.mCameraStates.length) {
                        ((RtcVideoStreamMgrImpl)RtcVideoStreamMgrImpl.this).mCameraStates[nCamId] = false;
                    }
                }
            };
            manager.registerAvailabilityCallback((CameraManager.AvailabilityCallback)this.mCameraCallback, null);
            this.mAppLifecycleCallback = new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- onActivityResumed ----- " + activity.toString());
                    RtcVideoStreamMgrImpl.this.mIsAppInBackground = false;
                    RtcVideoStreamMgrImpl.this.recoverLocalVideoState();
                }

                public void onActivityPaused(Activity activity) {
                    PLogger.i(RtcVideoStreamMgrImpl.TAG, "----- onActivityPaused ----- " + activity.toString());
                    RtcVideoStreamMgrImpl.this.mIsAppInBackground = true;
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            Application app = (Application)GlobalRef.applicationContext.getApplicationContext();
            app.registerActivityLifecycleCallbacks(this.mAppLifecycleCallback);
        }
    }

    private void unregisterCameraCallback() {
        if (Build.VERSION.SDK_INT >= 21 && this.mCameraCallback != null) {
            CameraManager manager = (CameraManager)GlobalRef.applicationContext.getSystemService("camera");
            manager.unregisterAvailabilityCallback((CameraManager.AvailabilityCallback)this.mCameraCallback);
            this.mCameraCallback = null;
            if (this.mAppLifecycleCallback != null) {
                Application app = (Application)GlobalRef.applicationContext.getApplicationContext();
                app.unregisterActivityLifecycleCallbacks(this.mAppLifecycleCallback);
                this.mAppLifecycleCallback = null;
                this.mIsAppInBackground = false;
            }
        }
    }

    private boolean isCameraAvailable(String cameraId) {
        int nCamId = Integer.parseInt(cameraId);
        if (nCamId >= 0 && nCamId < this.mCameraStates.length) {
            return this.mCameraStates[nCamId];
        }
        return true;
    }

    private boolean isCameraCallbackRegistered() {
        return this.mCameraCallback != null;
    }

    private boolean hasVideoStreamStarted() {
        int nsize = this.mStreamList.size();
        for (int i = 0; i < nsize; ++i) {
            StreamInfo stream = (StreamInfo)this.mStreamList.valueAt(i);
            if (!stream.started) continue;
            return true;
        }
        return false;
    }

    void recoverLocalVideoState() {
        PLogger.ni(TAG, "VideoStreamMgr.recoverLocalVideoState, b=" + this.mIsAppInBackground + ", f=" + this.mFailoverFlag);
        if (this.mIsAppInBackground || this.mFailoverFlag) {
            return;
        }
        int nsize = this.mStreamList.size();
        for (int i = 0; i < nsize; ++i) {
            StreamInfo stream = (StreamInfo)this.mStreamList.valueAt(i);
            if (!stream.started || !stream.restartFlag) continue;
            if (this.isCameraAvailable(stream.cameraId)) {
                this.recoverLocalVideoStream(stream);
                continue;
            }
            PLogger.nw(TAG, "VideoStreamMgr.recoverLocalVideoState, camera is still in use, id=" + stream.cameraId);
        }
    }

    private void recoverLocalVideoStream(StreamInfo stream) {
        PLogger.ni(TAG, "VideoStreamMgr.recoverLocalVideoStream, s=" + stream.started + ", r=" + stream.restartFlag + ", f=" + this.mFailoverFlag);
        if (stream.started && stream.restartFlag && !this.mFailoverFlag) {
            PLogger.ni(TAG, "VideoStreamMgr.recoverLocalVideoStream, restart video, streamId=" + stream.streamId + ", mute=" + stream.muted);
            ProxyVideoRender render = this.getLocalProxyRender(stream.streamId);
            Constants.QResult ret = Constants.QResult.valueOf(this.startVideo(this.mNativeHandle, stream.streamId, render, stream.profile.getValue()));
            if (ret == Constants.QResult.OK) {
                PLogger.ni(TAG, "VideoStreamMgr.recoverLocalVideoStream, video restarted");
                stream.restartFlag = false;
                if (stream.muted) {
                    this.muteVideo(this.mNativeHandle, stream.streamId);
                }
            } else {
                PLogger.ni(TAG, "VideoStreamMgr.recoverLocalVideoState, restart video failed, ret=" + (Object)((Object)ret));
            }
        }
    }

    static String getCameraId(String deviceId) {
        int idx = deviceId.indexOf(44);
        String str = idx > 0 ? deviceId.substring(0, idx) : deviceId;
        idx = str.indexOf(32);
        if (idx > 0) {
            str = str.substring(idx);
        }
        str = str.trim();
        return str;
    }

    static boolean verifyCameraId(String cameraId) {
        CameraManager manager;
        if (Build.VERSION.SDK_INT >= 21 && (manager = (CameraManager)GlobalRef.applicationContext.getSystemService("camera")) != null) {
            try {
                String[] ids;
                for (String camId : ids = manager.getCameraIdList()) {
                    if (!camId.equals(cameraId)) continue;
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    void addStream(int streamId, StreamInfo stream) {
        this.mStreamList.put(streamId, (Object)stream);
    }

    StreamInfo getStream(int streamId) {
        return (StreamInfo)this.mStreamList.get(streamId);
    }

    void removeStream(int streamId) {
        this.mStreamList.remove(streamId);
    }

    StreamInfo getActiveStream(String cameraId) {
        int nsize = this.mStreamList.size();
        for (int i = 0; i < nsize; ++i) {
            StreamInfo stream = (StreamInfo)this.mStreamList.valueAt(i);
            if (!stream.started || !stream.cameraId.equals(cameraId)) continue;
            return stream;
        }
        return null;
    }

    void onLocalVideoStreamStarted(int streamId, Constants.VideoProfileType profileType) {
        StreamInfo stream = this.getStream(streamId);
        if (stream != null) {
            stream.profile = profileType;
            stream.started = true;
        }
        if (!this.isCameraCallbackRegistered()) {
            this.registerCameraCallback();
        }
    }

    void onLocalVideoStreamStopped(int streamId) {
        StreamInfo stream = this.getStream(streamId);
        if (stream != null) {
            stream.started = false;
            stream.muted = false;
            stream.restartFlag = false;
        }
        if (!this.hasVideoStreamStarted()) {
            this.unregisterCameraCallback();
        }
    }

    void onLocalVideoStreamMuteState(int streamId, boolean muted) {
        StreamInfo stream = this.getStream(streamId);
        if (stream != null) {
            stream.muted = muted;
        }
    }

    void clearForLeave() {
        ProxyVideoRender defaultRender = null;
        StreamInfo stream = this.getStream(0);
        if (stream == null || !stream.started) {
            defaultRender = (ProxyVideoRender)this.mLocalVideoRenders.get(0);
        }
        this.mLocalVideoRenders.clear();
        if (defaultRender != null) {
            this.mLocalVideoRenders.put(0, (Object)defaultRender);
        }
        this.mRemoteVideoRenders.clear();
        this.mStreamList.clear();
        this.mFailoverFlag = false;
        Arrays.fill(this.mCameraStates, true);
    }

    public void notifyChannelFailover(Constants.FailoverState state) {
        PLogger.i(TAG, "VideoStreamMgr.notifyChannelFailover, state=" + (Object)((Object)state));
        if (state == Constants.FailoverState.Reconnecting) {
            this.mFailoverFlag = true;
        } else if (state == Constants.FailoverState.Success) {
            this.mFailoverFlag = false;
            this.recoverLocalVideoState();
        }
    }

    @Override
    public void onUserVideoStart(long userId, int streamId, int maxProfile) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoStart(userId, streamId, RtcEngineImpl.ToVideoProfileType(maxProfile));
        }
    }

    @Override
    public void onUserVideoStop(long userId, int streamId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoStop(userId, streamId);
        }
    }

    @Override
    public void onUserVideoSubscribe(long userId, int streamId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoSubscribe(userId, streamId, RtcEngineImpl.ToMediaSubscribeResult(result));
        }
    }

    @Override
    public void onUserVideoMute(long userId, int streamId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoMute(userId, streamId);
        }
    }

    @Override
    public void onUserVideoUnmute(long userId, int streamId) {
        if (this.mCallback != null) {
            this.mCallback.onUserVideoUnmute(userId, streamId);
        }
    }

    @Override
    public void onFirstVideoDataReceived(long userId, int streamId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstVideoDataReceived(userId, streamId);
        }
    }

    @Override
    public void onFirstVideoFrameRendered(long userId, int streamId) {
        if (this.mCallback != null) {
            this.mCallback.onFirstVideoFrameRendered(userId, streamId);
        }
    }

    @Override
    public void onVideoSnapshotCompleted(long userId, int streamId, boolean succeed, String filename) {
        if (this.mCallback != null) {
            this.mCallback.onVideoSnapshotCompleted(userId, streamId, succeed, filename);
        }
    }

    @Override
    public void onVideoCaptureStateChanged(int streamId, String deviceId, int state) {
        if (this.mCallback != null) {
            this.mCallback.onVideoCaptureStateChanged(streamId, deviceId, RtcEngineImpl.ToVideoCaptureState(state));
        }
    }

    @Override
    public void onVideoStartResult(int streamId, int result) {
        if (this.mCallback != null) {
            this.mCallback.onVideoStartResult(streamId, Constants.QResult.valueOf(result));
        }
    }

    private native int setCallback(long var1, RtcVideoStreamMgrCallback var3);

    private native int createVideoStream(long var1, String var3);

    private native int destroyVideoStream(long var1, int var3);

    private native int setCaptureDevice(long var1, int var3, String var4);

    private native String getCaptureDevice(long var1, int var3);

    private native int startVideo(long var1, int var3, IVideoRender var4, int var5);

    private native int stopVideo(long var1, int var3);

    private native int muteVideo(long var1, int var3);

    private native int unmuteVideo(long var1, int var3);

    private native int subscribeVideo(long var1, long var3, int var5, IVideoRender var6, int var7);

    private native int unsubscribeVideo(long var1, long var3, int var5);

    private native int snapshotVideo(long var1, long var3, int var5, String var6, int var7, boolean var8);

    static class StreamInfo {
        int streamId = 0;
        Constants.VideoProfileType profile;
        String deviceId = "";
        String cameraId = "";
        boolean started = false;
        boolean muted = false;
        boolean restartFlag = false;

        StreamInfo() {
        }
    }
}

