/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.view.View;
import android.view.ViewParent;
import com.pano.rtc.api.Constants;
import com.pano.rtc.api.PanoCoursePageView;
import com.pano.rtc.api.RtcWbView;
import com.pano.rtc.api.RtcWhiteboard;
import com.pano.rtc.api.WBDocContents;
import com.pano.rtc.api.WBDocConvertConfig;
import com.pano.rtc.api.WBDocExtContents;
import com.pano.rtc.api.WBDocExtHtml;
import com.pano.rtc.api.WBDocInfo;
import com.pano.rtc.api.WBDrawEvent;
import com.pano.rtc.api.WBStamp;
import com.pano.rtc.api.WBVisionConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import video.pano.rtc.impl.GestureHandler;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.whiteboard.RtcWbCallbackImpl;
import video.pano.rtc.impl.whiteboard.RtcWbDrawer;
import video.pano.rtc.impl.whiteboard.WBDocContentsImpl;
import video.pano.rtc.impl.whiteboard.WBDocConvertConfigImpl;
import video.pano.rtc.impl.whiteboard.WBDocExtContentsImpl;
import video.pano.rtc.impl.whiteboard.WBDocExtHtmlImpl;
import video.pano.rtc.impl.whiteboard.WBDocInfoImpl;
import video.pano.rtc.impl.whiteboard.WBNative;

public class RtcWhiteboardImpl
implements RtcWhiteboard,
RtcWbCallbackImpl {
    private long mNativeHandle;
    private final String mWhiteboardId;
    private String mOldWhiteboardId;
    private PanoCoursePageView mView;
    private RtcWbView mWbView;
    private RtcWbView.Callback mViewCallback;
    private RtcWhiteboard.Callback mWbCallback;
    private final RtcWbDrawer mWbDrawer;
    private boolean mEnableDrawer;
    private final Map<String, WBDocInfo> mDocInfoMap = new HashMap<String, WBDocInfo>();
    private int mBgColor = -1;

    RtcWhiteboardImpl(long nativeHandle, String wbId) {
        this.mNativeHandle = nativeHandle;
        this.mWhiteboardId = wbId;
        this.mWbDrawer = new RtcWbDrawer(this.mNativeHandle, this.mWhiteboardId, new RtcWbDrawer.Callback(){

            @Override
            public void onGestureHandlerAdd(GestureHandler gesHandler) {
                if (RtcWhiteboardImpl.this.mWbView != null) {
                    RtcWhiteboardImpl.this.mWbView.setRtcTouchListener((v, event) -> gesHandler.handleEvent(event));
                }
            }

            @Override
            public void onGestureHandlerRemove() {
                if (RtcWhiteboardImpl.this.mWbView != null) {
                    RtcWhiteboardImpl.this.mWbView.setRtcTouchListener(null);
                }
            }

            @Override
            public void onActionBegin() {
                RtcWhiteboardImpl.this.mOldWhiteboardId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
            }

            @Override
            public void onActionEnd() {
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mOldWhiteboardId);
            }
        });
        this.mEnableDrawer = true;
    }

    @Override
    public Constants.QResult setCallback(RtcWhiteboard.Callback callback) {
        this.mWbCallback = callback;
        WBNative.WBSetCallback(this.mNativeHandle, this);
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult setRoleType(Constants.WBRoleType role) {
        int ret = WBNative.WBSetRoleType(this.mNativeHandle, role.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult open(final RtcWbView view) {
        WBNative.WBOpen(this.mNativeHandle, (View)view);
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBSurfaceReady(RtcWhiteboardImpl.this.getNativeHandle(), view.getHolder().getSurface());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBUpdateViewSize(RtcWhiteboardImpl.this.getNativeHandle(), w, h);
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewDestroyed() {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBSurfaceDestroyed(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }
        };
        view.addCallback(this.mViewCallback);
        this.mWbView = view;
        ViewParent parent = this.mWbView.getParent();
        if (parent instanceof PanoCoursePageView) {
            ((PanoCoursePageView)parent).setBackgroundColor(this.mBgColor);
            this.mView = (PanoCoursePageView)parent;
        }
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, (View)view);
        }
        if (view.isViewReady()) {
            int ret = WBNative.WBSurfaceReady(this.mNativeHandle, view.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult open(PanoCoursePageView view) {
        RtcWbView wbView;
        this.mView = view;
        WBNative.WBOpen(this.mNativeHandle, (View)view);
        this.mWbView = wbView = view.getAttachRtcWbView();
        this.mViewCallback = new RtcWbView.Callback(){

            @Override
            public void onViewReady(int w, int h) {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBSurfaceReady(RtcWhiteboardImpl.this.getNativeHandle(), wbView.getHolder().getSurface());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewSizeChanged(int w, int h) {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBUpdateViewSize(RtcWhiteboardImpl.this.getNativeHandle(), w, h);
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }

            @Override
            public void onViewDestroyed() {
                String wbId = WBNative.WBGetCurrentWhiteboardId(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), RtcWhiteboardImpl.this.mWhiteboardId);
                WBNative.WBSurfaceDestroyed(RtcWhiteboardImpl.this.getNativeHandle());
                WBNative.WBSwitch(RtcWhiteboardImpl.this.getNativeHandle(), wbId);
            }
        };
        wbView.addCallback(this.mViewCallback);
        view.setBackgroundColor(this.mBgColor);
        if (this.mEnableDrawer) {
            this.mWbDrawer.start(GlobalRef.applicationContext, (View)wbView);
        }
        if (wbView.isViewReady()) {
            int ret = WBNative.WBSurfaceReady(this.mNativeHandle, wbView.getHolder().getSurface());
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult close() {
        if (this.mEnableDrawer) {
            this.mWbDrawer.stop();
        }
        if (this.mWbView != null) {
            ViewParent parent = this.mWbView.getParent();
            if (parent != null && parent instanceof PanoCoursePageView) {
                ((PanoCoursePageView)parent).close();
            }
            this.mWbView.removeCallback(this.mViewCallback);
            this.mViewCallback = null;
            this.mWbView = null;
        }
        if (this.mNativeHandle != 0L) {
            int ret = WBNative.WBSurfaceDestroyed(this.mNativeHandle);
            ret = WBNative.WBClose(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult leave() {
        this.close();
        if (this.mNativeHandle != 0L) {
            int ret = WBNative.WBLeave(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult stop() {
        this.close();
        if (this.mNativeHandle != 0L) {
            int ret = WBNative.WBStop(this.mNativeHandle);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult importFrom(String filename) {
        if (this.mNativeHandle != 0L) {
            int ret = WBNative.WBImport(this.mNativeHandle, filename);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult exportTo(String filename) {
        if (this.mNativeHandle != 0L) {
            int ret = WBNative.WBExport(this.mNativeHandle, filename);
            return Constants.QResult.valueOf(ret);
        }
        return Constants.QResult.OK;
    }

    long getNativeHandle() {
        return this.mNativeHandle;
    }

    void destroy() {
        this.close();
        this.mDocInfoMap.clear();
        this.mNativeHandle = 0L;
    }

    @Override
    public String getCurrentWhiteboardId() {
        return WBNative.WBGetCurrentWhiteboardId(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setCurrentScaleFactor(float scale) {
        int ret = WBNative.WBSetCurrentScaleFactor(this.mNativeHandle, scale);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public int getCurrentPageNumber() {
        return WBNative.WBGetCurrentPageNumber(this.mNativeHandle);
    }

    @Override
    public int getTotalNumberOfPages() {
        return WBNative.WBGetTotalNumberOfPages(this.mNativeHandle);
    }

    @Override
    public float getCurrentScaleFactor() {
        return WBNative.WBGetCurrentScaleFactor(this.mNativeHandle);
    }

    @Override
    public Constants.QResult setBackgroundImage(String imageUrl) {
        int ret = WBNative.WBSetBackgroundImage(this.mNativeHandle, imageUrl, this.getCurrentPageNumber());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundImage(String imageUrl, int pageNo) {
        int ret = WBNative.WBSetBackgroundImage(this.mNativeHandle, imageUrl, pageNo);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setToolType(Constants.WBToolType type) {
        if (this.mWbView != null) {
            this.mWbView.setPassThrough(type == Constants.WBToolType.None);
        }
        int ret = WBNative.WBSetToolType(this.mNativeHandle, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.WBToolType getToolType() {
        int type = WBNative.WBGetToolType(this.mNativeHandle);
        return Constants.WBToolType.valueOf(type);
    }

    @Override
    public RtcWbView getAttachedRtcWbView() {
        return this.mWbView;
    }

    @Override
    public PanoCoursePageView getAttachedCoursePageView() {
        return this.mView;
    }

    @Override
    public Constants.QResult setLineWidth(int size) {
        int ret = WBNative.WBSetLineWidth(this.mNativeHandle, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillType(Constants.WBFillType type) {
        int ret = WBNative.WBSetFillType(this.mNativeHandle, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFillColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setFillColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setFillColor(float r, float g, float b, float a) {
        int ret = WBNative.WBSetFillColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setForegroundColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setForegroundColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setForegroundColor(float r, float g, float b, float a) {
        int ret = WBNative.WBSetForegroundColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundColor(int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >>> 24) / 255.0f;
        return this.setBackgroundColor(r, g, b, a);
    }

    @Override
    public Constants.QResult setBackgroundColor(float r, float g, float b, float a) {
        ViewParent parent;
        int alpha = (int)(a * 255.0f) & 0xFF;
        int red = (int)(r * 255.0f) & 0xFF;
        int green = (int)(g * 255.0f) & 0xFF;
        int blue = (int)(b * 255.0f) & 0xFF;
        this.mBgColor = alpha << 24 | red << 16 | green << 8 | blue;
        if (this.mWbView != null && (parent = this.mWbView.getParent()) instanceof PanoCoursePageView) {
            ((PanoCoursePageView)parent).setBackgroundColor(this.mBgColor);
        }
        int ret = WBNative.WBSetBackgroundColor(this.mNativeHandle, r, g, b, a);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setBackgroundImageScalingMode(Constants.WBImageScalingMode mode) {
        int ret = WBNative.WBSetBackgroundImageScalingMode(this.mNativeHandle, mode.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontStyle(Constants.WBFontStyle style) {
        int ret = WBNative.WBSetFontStyle(this.mNativeHandle, style.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFontSize(int size) {
        int ret = WBNative.WBSetFontSize(this.mNativeHandle, size);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addStamp(WBStamp stamp) {
        int ret = WBNative.WBAddStamp(this.mNativeHandle, stamp.stampId, stamp.path, stamp.resizable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setStamp(String stampId) {
        int ret = WBNative.WBSetStamp(this.mNativeHandle, stampId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult undo() {
        int ret = WBNative.WBUndo(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult redo() {
        int ret = WBNative.WBRedo(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addPage(boolean autoSwitch) {
        int ret = WBNative.WBAddPage(this.mNativeHandle, autoSwitch);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult insertPage(int pageNo, boolean autoSwitch) {
        int ret = WBNative.WBInsertPage(this.mNativeHandle, pageNo, autoSwitch);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult removePage(int pageNo) {
        int ret = WBNative.WBRemovePage(this.mNativeHandle, pageNo, false);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult removePage(int pageNo, boolean switchNext) {
        int ret = WBNative.WBRemovePage(this.mNativeHandle, pageNo, switchNext);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult gotoPage(int pageNo) {
        int ret = WBNative.WBGotoPage(this.mNativeHandle, pageNo);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult prevPage() {
        int ret = WBNative.WBPrevPage(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult nextPage() {
        int ret = WBNative.WBNextPage(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult prevStep() {
        int ret = WBNative.WBPrevStep(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult nextStep() {
        int ret = WBNative.WBNextStep(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addImageFile(String imageUrl) {
        int ret = WBNative.WBAddImage(this.mNativeHandle, imageUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addAudioFile(String mediaUrl) {
        int ret = WBNative.WBAddAudio(this.mNativeHandle, mediaUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult addVideoFile(String mediaUrl) {
        int ret = WBNative.WBAddVideo(this.mNativeHandle, mediaUrl);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public String addBackgroundImages(List<String> urls) {
        return WBNative.WBAddBackgroundImages(this.mNativeHandle, urls);
    }

    @Override
    public String addH5File(String url, String downloadUrl) {
        return WBNative.WBAddH5File(this.mNativeHandle, url, downloadUrl);
    }

    @Override
    public String addDoc(WBDocContents contents) {
        WBDocContentsImpl jcontent = new WBDocContentsImpl();
        jcontent.name = contents.name;
        jcontent.urls = contents.urls != null ? contents.urls.toArray(new String[contents.urls.size()]) : new String[0];
        jcontent.thumbUrls = contents.thumbUrls != null ? contents.thumbUrls.toArray(new String[contents.thumbUrls.size()]) : new String[0];
        jcontent.docId = contents.docId;
        jcontent.type = contents.type.getValue();
        return WBNative.WBAddDoc(this.mNativeHandle, jcontent);
    }

    @Override
    public String addDoc(WBDocExtHtml contents) {
        WBDocExtHtmlImpl jcontent = new WBDocExtHtmlImpl();
        jcontent.name = contents.name;
        jcontent.url = contents.url;
        jcontent.thumbUrls = contents.thumbUrls != null ? contents.thumbUrls.toArray(new String[contents.thumbUrls.size()]) : new String[0];
        return WBNative.WBAddDocWithExtHtml(this.mNativeHandle, jcontent);
    }

    @Override
    public String addDoc(WBDocExtContents contents) {
        WBDocExtContentsImpl jcontent = new WBDocExtContentsImpl();
        jcontent.name = contents.name;
        jcontent.totalPages = contents.totalPages;
        jcontent.width = contents.width;
        jcontent.height = contents.height;
        return WBNative.WBAddDocWithExtContents(this.mNativeHandle, jcontent);
    }

    @Override
    public String createDoc(List<String> imageUrls) {
        return WBNative.WBCreateDocWithImages(this.mNativeHandle, imageUrls);
    }

    @Override
    public String createDoc(String filePath) {
        return WBNative.WBCreateDocWithFilePath(this.mNativeHandle, filePath);
    }

    @Override
    public String createDoc(String filePath, WBDocConvertConfig config) {
        WBDocConvertConfigImpl jConfig = new WBDocConvertConfigImpl();
        jConfig.setType(config.type.getValue());
        jConfig.setNeedThumb(config.needThumb);
        jConfig.setLifeType(config.lifeType);
        jConfig.setMeta(config.meta);
        return WBNative.WBCreateDocWithConfig(this.mNativeHandle, filePath, jConfig);
    }

    @Override
    public Constants.QResult deleteDoc(String fileId) {
        int ret = WBNative.WBDeleteDoc(this.mNativeHandle, fileId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult switchDoc(String fileId) {
        int ret = WBNative.WBSwitchDoc(this.mNativeHandle, fileId);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult saveDocToImages(String fileId, String outputDir) {
        int ret = WBNative.WBSaveDocToImages(this.mNativeHandle, fileId, outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public List<String> enumerateFiles() {
        String[] array = WBNative.WBEnumFiles(this.mNativeHandle);
        if (null == array) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(array));
    }

    @Override
    public String getCurrentFileId() {
        return WBNative.WBGetCurrentFileId(this.mNativeHandle);
    }

    @Override
    public WBDocInfo getFileInfo(String fileId) {
        if (null == this.mDocInfoMap.get(fileId)) {
            WBDocInfoImpl docInfo = new WBDocInfoImpl();
            WBNative.WBGetFileInfo(this.mNativeHandle, fileId, docInfo);
            WBDocInfo info = new WBDocInfo();
            info.fileId = docInfo.getFileID();
            info.name = docInfo.getName();
            info.creator = docInfo.getCreator();
            info.type = docInfo.getType();
            info.docId = docInfo.getDocId();
            this.mDocInfoMap.put(fileId, info);
        }
        return this.mDocInfoMap.get(fileId);
    }

    @Override
    public Constants.QResult sendMessageToExternalHtml(String fileId, String msg) {
        int ret = WBNative.WBSendMessageToExternalHtml(this.mNativeHandle, fileId, msg);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearContents(boolean curPage, Constants.WBClearType type) {
        int ret = WBNative.WBClearContents(this.mNativeHandle, curPage, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearUserContents(long userId, boolean curPage, Constants.WBClearType type) {
        int ret = WBNative.WBClearUserContents(this.mNativeHandle, userId, curPage, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult clearDocContents(String fileId, Constants.WBClearType type) {
        int ret = WBNative.WBClearDocContents(this.mNativeHandle, fileId, type.getValue());
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult snapshot(Constants.WBSnapshotMode mode, String outputDir) {
        int ret = WBNative.WBSnapshot(this.mNativeHandle, mode.getValue(), outputDir);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult initVision(WBVisionConfig config) {
        int ret = WBNative.WBInitVision(this.mNativeHandle, config.width, config.height, config.limited);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult resetVision() {
        int ret = WBNative.WBResetVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startShareVision() {
        int ret = WBNative.WBStartShareVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult stopShareVision() {
        int ret = WBNative.WBStopShareVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult startFollowVision() {
        int ret = WBNative.WBStartFollowVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult stopFollowVision() {
        int ret = WBNative.WBStopFollowVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult syncVision() {
        int ret = WBNative.WBSyncVision(this.mNativeHandle);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult sendMessage(long userId, byte[] msg) {
        int ret = WBNative.WBSendMessage(this.mNativeHandle, userId, msg);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult broadcastMessage(byte[] msg) {
        int ret = WBNative.WBBroadcastMessage(this.mNativeHandle, msg);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult setFileCachePath(String path) {
        int ret = WBNative.WBSetFileCachePath(this.mNativeHandle, path);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableUIResponse(boolean enable) {
        if (enable && !this.mEnableDrawer) {
            if (this.mWbView != null) {
                this.mWbDrawer.start(GlobalRef.applicationContext, (View)this.mWbView);
            }
        } else if (!enable && this.mEnableDrawer && this.mWbView != null) {
            this.mWbDrawer.stop();
        }
        if (this.mView != null) {
            this.mView.enableTouchEvent(enable);
        }
        this.mEnableDrawer = enable;
        return Constants.QResult.OK;
    }

    @Override
    public Constants.QResult enableShowDraws(boolean enable) {
        int ret = WBNative.WBEnableShowDraws(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableScaleMove(boolean enable) {
        int ret = WBNative.WBEnableScaleMove(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableAutoSelected(boolean enable) {
        int ret = WBNative.WBEnableAutoSelected(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableCursorPosSync(boolean enable) {
        int ret = WBNative.WBEnableCursorPosSync(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public Constants.QResult enableShowRemoteCursor(boolean enable) {
        int ret = WBNative.WBEnableShowRemoteCursor(this.mNativeHandle, enable);
        return Constants.QResult.valueOf(ret);
    }

    @Override
    public void onStatusSynced() {
        if (this.mWbCallback != null) {
            this.mWbCallback.onStatusSynced();
        }
    }

    @Override
    public void onPageNumberChanged(int curPage, int totalPages) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onPageNumberChanged(curPage, totalPages);
        }
    }

    @Override
    public void onImageStateChanged(String url, int state) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onImageStateChanged(url, this.ToWBImageState(state));
        }
    }

    @Override
    public void onHtmlStateChanged(String fileId, String url, int state) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onHtmlStateChanged(fileId, url, this.ToWBHtmlState(state));
        }
    }

    @Override
    public void onViewScaleChanged(float scale) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onViewScaleChanged(scale);
        }
    }

    @Override
    public void onRoleTypeChanged(int newRole) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onRoleTypeChanged(this.ToWBRoleType(newRole));
        }
    }

    @Override
    public void onContentUpdated() {
        if (this.mWbCallback != null) {
            this.mWbCallback.onContentUpdated();
        }
    }

    @Override
    public void onSnapshotComplete(int result, String filename) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSnapshotComplete(qr, filename);
        }
    }

    @Override
    public void onMessage(long userId, byte[] msg) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onMessage(userId, msg);
        }
    }

    @Override
    public void onAddBackgroundImages(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onAddBackgroundImages(qr, fileId);
        }
    }

    @Override
    public void onAddH5File(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onAddH5File(qr, fileId);
        }
    }

    @Override
    public void onDocTranscodeStatus(int result, String fileId, int progress, int totalPages) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onDocTranscodeStatus(qr, fileId, progress, totalPages);
        }
    }

    @Override
    public void onCreateDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onCreateDoc(qr, fileId);
        }
    }

    @Override
    public void onDeleteDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onDeleteDoc(qr, fileId);
        }
    }

    @Override
    public void onSwitchDoc(int result, String fileId) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSwitchDoc(qr, fileId);
        }
    }

    @Override
    public void onSaveDoc(int result, String fileId, String outputDir) {
        if (this.mWbCallback != null) {
            Constants.QResult qr = Constants.QResult.valueOf(result);
            this.mWbCallback.onSaveDoc(qr, fileId, outputDir);
        }
    }

    @Override
    public void onDocThumbnailReady(String fileId, String[] urls) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onDocThumbnailReady(fileId, Arrays.asList(urls));
        }
    }

    @Override
    public void onExternalHtmlMessageReceived(String fileId, String message) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onExternalHtmlMessageReceived(fileId, message);
        }
    }

    @Override
    public void onVisionShareStarted(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onVisionShareStarted(userId);
        }
    }

    @Override
    public void onVisionShareStopped(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onVisionShareStopped(userId);
        }
    }

    @Override
    public void onUserJoined(long userId, String userName) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onUserJoined(userId, userName);
        }
    }

    @Override
    public void onUserLeft(long userId) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onUserLeft(userId);
        }
    }

    @Override
    public void onUndoStatusChanged(boolean canUndo) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onUndoStatusChanged(canUndo);
        }
    }

    @Override
    public void onRedoStatusChanged(boolean canRedo) {
        if (this.mWbCallback != null) {
            this.mWbCallback.onRedoStatusChanged(canRedo);
        }
    }

    @Override
    public void onDrawEvent(int type) {
        if (this.mWbCallback != null) {
            WBDrawEvent event = new WBDrawEvent();
            event.type = this.ToWBDrawEventType(type);
            this.mWbCallback.onDrawEvent(event);
        }
    }

    private Constants.WBImageState ToWBImageState(int state) {
        Constants.WBImageState result = Constants.WBImageState.LoadFail;
        for (Constants.WBImageState val : Constants.WBImageState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.WBHtmlState ToWBHtmlState(int state) {
        Constants.WBHtmlState result = Constants.WBHtmlState.LoadTimeout;
        for (Constants.WBHtmlState val : Constants.WBHtmlState.values()) {
            if (val.getValue() != state) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.WBRoleType ToWBRoleType(int type) {
        Constants.WBRoleType result = Constants.WBRoleType.Attendee;
        for (Constants.WBRoleType val : Constants.WBRoleType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }

    private Constants.WBDrawEventType ToWBDrawEventType(int type) {
        Constants.WBDrawEventType result = Constants.WBDrawEventType.DrawStart;
        for (Constants.WBDrawEventType val : Constants.WBDrawEventType.values()) {
            if (val.getValue() != type) continue;
            result = val;
            break;
        }
        return result;
    }
}

