/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.impl;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import com.pano.rtc.impl.ExternalAudioPlayerImpl;
import com.pano.rtc.impl.RtcAudioDeviceMgrImpl;
import java.io.File;
import video.pano.rtc.base.annotation.CalledByNative;
import video.pano.rtc.base.util.DeviceUuid;
import video.pano.rtc.base.util.NetworkChangeObserver;
import video.pano.rtc.base.util.NetworkChangeReceiver;
import video.pano.rtc.base.util.NetworkUtils;
import video.pano.rtc.base.util.SystemPermissionUtils;
import video.pano.rtc.impl.GlobalRef;
import video.pano.rtc.impl.PLogger;

public class UnityWrapper {
    private static final String TAG = "UnityWrapper";
    private static Context mContext;
    private static boolean mHasInit;
    private NetworkChangeReceiver mNetworkChangeReceiver;
    private RtcAudioDeviceMgrImpl mAudioDeviceMgr;
    private ExternalAudioPlayerImpl mExAudioPlayer;
    private boolean mExAudioPlayerEnableStatus = false;
    private int mAudioMode = 3;
    private long mNativeHandle;

    public static int init(Context context) {
        if (context == null) {
            return -1;
        }
        if (mHasInit) {
            return 0;
        }
        mContext = context.getApplicationContext();
        GlobalRef.init(mContext);
        com.pano.coco.impl.GlobalRef.init(mContext);
        try {
            System.loadLibrary("panortc");
        }
        catch (Exception e) {
            return -2;
        }
        PLogger.initLogger(mContext);
        SystemPermissionUtils.checkSelfPermission(mContext);
        UnityWrapper.setupDefaultCachePath(mContext);
        UnityWrapper.setAndroidInfo(Build.VERSION.RELEASE, Build.MODEL, Build.MANUFACTURER, Build.BOARD);
        UnityWrapper.initNative(mContext, DeviceUuid.getDeviceID(GlobalRef.applicationContext));
        mHasInit = true;
        return 0;
    }

    @CalledByNative
    public UnityWrapper(long handle) {
        this.mNativeHandle = handle;
        this.mAudioDeviceMgr = new RtcAudioDeviceMgrImpl(this.mNativeHandle);
        this.mExAudioPlayer = new ExternalAudioPlayerImpl(this.mNativeHandle);
        this.loadEngineSettings();
        this.setupNetworkChangeReceiver(mContext);
        this.updateNetworkType();
    }

    @CalledByNative
    public void beforeJoinChannel() {
        this.updateNetworkType();
    }

    @CalledByNative
    public void afterJoinChannel() {
        if (this.mAudioDeviceMgr != null) {
            this.mExAudioPlayerEnableStatus = this.mExAudioPlayer.getEnableStatus();
            int audioMode = this.mExAudioPlayerEnableStatus ? -1 : this.mAudioMode;
            this.mAudioDeviceMgr.start(0, audioMode);
        }
    }

    @CalledByNative
    public void leaveChannel() {
        if (this.mAudioDeviceMgr != null) {
            this.mAudioDeviceMgr.stop();
        }
    }

    @CalledByNative
    public void setLoudspeakerStatus(boolean enable) {
        this.mAudioDeviceMgr.setLoudspeakerStatus(enable);
    }

    @CalledByNative
    public boolean isLoudspeakerOn() {
        return this.mAudioDeviceMgr.isLoudspeakerOn();
    }

    @CalledByNative
    public String getAudioDumpFilePath() {
        File extPath = mContext.getExternalFilesDir("data");
        if (extPath == null || -1 == mContext.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", mContext.getPackageName())) {
            extPath = mContext.getDir("data", 0);
        }
        String fileName = extPath.getAbsolutePath();
        fileName = fileName + "/pano_audio.dump";
        return fileName;
    }

    @CalledByNative
    public void destroy() {
        if (this.mNetworkChangeReceiver != null) {
            mContext.unregisterReceiver((BroadcastReceiver)this.mNetworkChangeReceiver);
        }
        this.mAudioDeviceMgr.releaseDeviceManager();
        this.mAudioDeviceMgr = null;
        this.mExAudioPlayer = null;
        this.mNativeHandle = 0L;
    }

    private void updateNetworkType() {
        NetworkUtils.NetworkType type = NetworkUtils.getConnectivityStatus(GlobalRef.applicationContext);
        UnityWrapper.updateNetworkType(type.getValue());
    }

    private static void setupDefaultCachePath(Context context) {
        File extPath = context.getExternalCacheDir();
        if (extPath == null || -1 == context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName())) {
            extPath = context.getCacheDir();
        }
        String cachePath = extPath.getAbsolutePath();
        cachePath = cachePath + "/mango/";
        File folder = new File(cachePath);
        boolean success = true;
        if (!folder.exists()) {
            success = folder.mkdir();
        }
        if (!success) {
            PLogger.nw(TAG, "RtcEngine.setupDefaultCachePath mkdir failed");
        }
    }

    private void loadEngineSettings() {
        SharedPreferences sp = GlobalRef.applicationContext.getSharedPreferences("panortc-settings", 0);
        this.mAudioMode = sp.getInt("AudioMode", 3);
    }

    private void setupNetworkChangeReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.setPriority(100);
        this.mNetworkChangeReceiver = new NetworkChangeReceiver(mContext);
        this.mNetworkChangeReceiver.setNetworkChangeObserver(new NetworkChangeObserver(){

            @Override
            public void onNetworkChanged(NetworkUtils.NetworkType type) {
                UnityWrapper.this.notifyNetworkChanged(UnityWrapper.this.mNativeHandle, type.getValue());
            }
        });
        context.registerReceiver((BroadcastReceiver)this.mNetworkChangeReceiver, intentFilter);
    }

    private static native void initNative(Context var0, String var1);

    private static native void setAndroidInfo(String var0, String var1, String var2, String var3);

    private static native void updateNetworkType(int var0);

    private native void notifyNetworkChanged(long var1, int var3);
}

