/*
 * Decompiled with CFR 0.152.
 */
package com.pano.rtc.video;

import com.pano.rtc.api.Constants;
import com.pano.rtc.api.RtcVideoTextureFilter;
import com.pano.rtc.api.RtcVideoTextureFilterConfig;
import com.pano.rtc.api.model.BuiltinTransformParams;
import com.pano.rtc.api.model.FaceBeautifyParams;
import com.pano.rtc.api.model.QuadTransformParams;
import com.pano.rtc.api.model.VideoBrightnessParams;
import com.pano.rtc.video.CocoCaptureFrameObserver;
import video.pano.EglBase;
import video.pano.rtc.impl.PLogger;

public class RtcCaptureObserver {
    private static final String TAG = "RtcCaptureObserver";
    public CocoCaptureFrameObserver cocoCaptureFrameObserver;
    public FaceBeautifyParams faceBeautifyParams = new FaceBeautifyParams();
    public boolean faceBeautifyDynamic = false;
    public boolean faceBeautifyTransferred = false;
    public BuiltinTransformParams builtinTransformParams = new BuiltinTransformParams();
    public boolean builtinTransformDynamic = false;
    public boolean builtinTransformTransferred = false;
    public QuadTransformParams quadTransformParams = new QuadTransformParams();
    public boolean quadTransformDynamic = false;
    public boolean quadTransformTransferred = false;
    public VideoBrightnessParams videoBrightnessParams = new VideoBrightnessParams();
    public boolean brightnessDynamic = false;
    public boolean brightnessTransferred = false;
    public RtcVideoTextureFilter externalFilter = null;
    public RtcVideoTextureFilterConfig externalFilterConfig = new RtcVideoTextureFilterConfig();
    public boolean externalFilterDynamic = false;
    public boolean externalFilterTransferred = false;

    public RtcCaptureObserver(EglBase.Context eglContext) {
        this.cocoCaptureFrameObserver = new CocoCaptureFrameObserver(eglContext);
        this.faceBeautifyParams.enable = false;
        this.builtinTransformParams.enable = false;
        this.quadTransformParams.enable = false;
        this.videoBrightnessParams.enable = false;
    }

    public Constants.QResult setFaceBeautify(FaceBeautifyParams param, boolean dynamic) {
        Constants.QResult ret = Constants.QResult.OK;
        if (this.faceBeautifyParams.enable != param.enable) {
            ret = this.cocoCaptureFrameObserver.enableInternalFilter(param.enable || this.builtinTransformParams.enable || this.quadTransformParams.enable || this.videoBrightnessParams.enable);
            this.cocoCaptureFrameObserver.setDoFaceBeauty(param.enable);
        }
        if (param.enable) {
            this.cocoCaptureFrameObserver.setBeautifyIntensity(param.intensity);
        }
        this.faceBeautifyParams.enable = param.enable;
        this.faceBeautifyParams.intensity = param.intensity;
        this.faceBeautifyDynamic = dynamic;
        return ret;
    }

    public Constants.QResult setFaceBeautifyEnable(boolean enable) {
        Constants.QResult ret = Constants.QResult.OK;
        if (this.faceBeautifyParams.enable != enable) {
            ret = this.cocoCaptureFrameObserver.enableInternalFilter(enable || this.builtinTransformParams.enable || this.quadTransformParams.enable || this.videoBrightnessParams.enable);
            this.cocoCaptureFrameObserver.setDoFaceBeauty(enable);
        }
        if (enable) {
            this.cocoCaptureFrameObserver.setBeautifyIntensity(this.faceBeautifyParams.intensity);
        }
        this.faceBeautifyParams.enable = enable;
        this.faceBeautifyDynamic = true;
        return ret;
    }

    public Constants.QResult updateFaceBeautifyIntensity(float intensity) {
        this.faceBeautifyParams.intensity = intensity;
        if (this.faceBeautifyParams.enable) {
            this.cocoCaptureFrameObserver.setBeautifyIntensity(this.faceBeautifyParams.intensity);
        }
        this.faceBeautifyDynamic = true;
        return Constants.QResult.OK;
    }

    public Constants.QResult setBuiltinTransform(BuiltinTransformParams param, boolean dynamic) {
        if (param.enable && this.quadTransformParams.enable) {
            PLogger.nw(TAG, "VideoQuadTransform is used already.");
            return Constants.QResult.InvalidArgs;
        }
        if (this.builtinTransformParams.enable != param.enable) {
            Constants.QResult ret = this.cocoCaptureFrameObserver.enableInternalFilter(this.faceBeautifyParams.enable || param.enable || this.quadTransformParams.enable || this.videoBrightnessParams.enable);
            if (ret != Constants.QResult.OK) {
                return ret;
            }
            this.cocoCaptureFrameObserver.setDoBuiltinTransform(param.enable);
        }
        if (param.enable) {
            boolean reset = param.bReset;
            float xScaling = param.xScaling;
            float yScaling = param.yScaling;
            float xRotation = param.xRotation;
            float yRotation = param.yRotation;
            float zRotation = param.zRotation;
            float xProjection = param.xProjection;
            float yProjection = param.yProjection;
            this.cocoCaptureFrameObserver.setBuiltinTransformParameters(reset, xScaling, yScaling, xRotation, yRotation, zRotation, xProjection, yProjection);
        }
        this.builtinTransformParams.enable = param.enable;
        this.builtinTransformParams.bReset = param.bReset;
        this.builtinTransformParams.xScaling = param.xScaling;
        this.builtinTransformParams.yScaling = param.yScaling;
        this.builtinTransformParams.xRotation = param.xRotation;
        this.builtinTransformParams.yRotation = param.yRotation;
        this.builtinTransformParams.zRotation = param.zRotation;
        this.builtinTransformParams.xProjection = param.xProjection;
        this.builtinTransformParams.yProjection = param.yProjection;
        this.builtinTransformDynamic = dynamic;
        return Constants.QResult.OK;
    }

    public Constants.QResult setQuadTransform(QuadTransformParams param, boolean dynamic) {
        if (this.builtinTransformParams.enable && param.enable) {
            PLogger.nw(TAG, "PanoOptionBuiltinTransform is used already.");
            return Constants.QResult.InvalidArgs;
        }
        if (this.quadTransformParams.enable != param.enable) {
            Constants.QResult ret = this.cocoCaptureFrameObserver.enableInternalFilter(this.faceBeautifyParams.enable || this.builtinTransformParams.enable || param.enable || this.videoBrightnessParams.enable);
            if (ret != Constants.QResult.OK) {
                return ret;
            }
            this.cocoCaptureFrameObserver.setDoBuiltinTransform(param.enable);
        }
        if (param.enable) {
            boolean reset = param.bReset;
            boolean mirror = param.bMirror;
            float xTopLeft = 0.0f;
            float yTopLeft = 0.0f;
            float xTopRight = 0.0f;
            float yTopRight = 0.0f;
            float xBottomLeft = 0.0f;
            float yBottomLeft = 0.0f;
            float xBottomRight = 0.0f;
            float yBottomRight = 0.0f;
            if (param.index.getValue() == Constants.QuadIndex.TopLeft.getValue()) {
                xTopLeft = param.xDeltaAxis;
                yTopLeft = param.yDeltaAxis;
            } else if (param.index.getValue() == Constants.QuadIndex.TopRight.getValue()) {
                xTopRight = param.xDeltaAxis;
                yTopRight = param.yDeltaAxis;
            } else if (param.index.getValue() == Constants.QuadIndex.BottomLeft.getValue()) {
                xBottomLeft = param.xDeltaAxis;
                yBottomLeft = param.yDeltaAxis;
            } else if (param.index.getValue() == Constants.QuadIndex.BottomRight.getValue()) {
                xBottomRight = param.xDeltaAxis;
                yBottomRight = param.yDeltaAxis;
            }
            this.cocoCaptureFrameObserver.setBuiltinTransformParameters(reset, mirror, xTopLeft, yTopLeft, xTopRight, yTopRight, xBottomLeft, yBottomLeft, xBottomRight, yBottomRight);
        }
        this.quadTransformParams.enable = param.enable;
        this.quadTransformParams.bReset = param.bReset;
        this.quadTransformParams.index = param.index;
        this.quadTransformParams.xDeltaAxis = param.xDeltaAxis;
        this.quadTransformParams.yDeltaAxis = param.yDeltaAxis;
        this.quadTransformParams.bMirror = param.bMirror;
        this.quadTransformDynamic = dynamic;
        return Constants.QResult.OK;
    }

    public Constants.QResult setVideoBrightness(VideoBrightnessParams param, boolean dynamic) {
        if (this.videoBrightnessParams.enable != param.enable) {
            Constants.QResult ret = this.cocoCaptureFrameObserver.enableInternalFilter(this.faceBeautifyParams.enable || this.builtinTransformParams.enable || this.quadTransformParams.enable || param.enable);
            if (ret != Constants.QResult.OK) {
                return ret;
            }
            this.cocoCaptureFrameObserver.setDoExtBrightness(param.enable);
        }
        if (param.enable) {
            this.cocoCaptureFrameObserver.setBrightness(param.brightness);
            this.cocoCaptureFrameObserver.setSmoothness(param.smoothness);
        }
        this.videoBrightnessParams.enable = param.enable;
        this.videoBrightnessParams.brightness = param.brightness;
        this.videoBrightnessParams.smoothness = param.smoothness;
        this.brightnessDynamic = dynamic;
        return Constants.QResult.OK;
    }

    public Constants.QResult setLocalVideoFilter(RtcVideoTextureFilter filter, RtcVideoTextureFilterConfig config, boolean dynamic, boolean release) {
        if (filter != this.externalFilter) {
            Constants.QResult ret = this.cocoCaptureFrameObserver.setExternalFilter(filter, config.textureType, config.withYuv, release);
            if (ret != Constants.QResult.OK) {
                PLogger.nw(TAG, "Failed to setLocalVideoFilter. Texture type conflict maybe.");
                return ret;
            }
            this.externalFilter = filter;
        }
        this.externalFilterConfig.textureType = config.textureType;
        this.externalFilterConfig.withYuv = config.withYuv;
        this.externalFilterDynamic = dynamic;
        return Constants.QResult.OK;
    }

    public void release() {
        this.cocoCaptureFrameObserver.release();
        this.externalFilter = null;
    }
}

