/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.api;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.MotionEvent;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.listener.OnErrorListener;
import com.github.barteksc.pdfviewer.listener.OnLoadCompleteListener;
import com.github.barteksc.pdfviewer.listener.OnPageChangeListener;
import com.github.barteksc.pdfviewer.listener.OnPageScrollListener;
import com.shockwave.pdfium.util.SizeF;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import video.pano.rtc.impl.PLogger;

public class PanoPdfView
extends PDFView {
    private static final String TAG = "PanoPdfView";
    private long mNativeHandle;
    private boolean mEnableTouchEvent = true;
    private String mShapeId;
    private String mUrl;
    private int mTotalPages = 0;
    private boolean mLoaded = false;

    public PanoPdfView(Context context) {
        super(context, null);
    }

    public PanoPdfView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void close() {
        PLogger.i(TAG, "close");
        this.mLoaded = false;
        this.recycle();
        this.mNativeHandle = 0L;
        this.mTotalPages = 0;
    }

    public void setEnableTouchEvent(boolean enable) {
        this.mEnableTouchEvent = enable;
        if (!enable) {
            this.setOnTouchListener(null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mEnableTouchEvent) {
            return super.onTouchEvent(event);
        }
        return true;
    }

    public void scrollTo(int page, float pos) {
        if (this.mTotalPages <= 0) {
            return;
        }
        PLogger.i(TAG, "scrollTo " + this.getCurrentYOffset() + "," + this.getPositionOffset());
        this.setPositionOffset(pos, true);
    }

    public void scaleTo(float scale, float x, float y) {
        if (!this.mLoaded) {
            return;
        }
        this.zoomTo(scale);
        this.moveTo(-x, -y);
        this.loadPages();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mNativeHandle = 0L;
        this.mTotalPages = 0;
        this.mLoaded = false;
        PLogger.i(TAG, "onDetachedFromWindow");
    }

    public void setShapeId(String shapeId) {
        this.mShapeId = shapeId;
    }

    public String getShapeId() {
        return this.mShapeId;
    }

    public void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void setPdfUrl(String url) {
        if (this.mUrl == url) {
            return;
        }
        this.mUrl = url;
        PDFView.Configurator config = this.fromUri(Uri.parse((String)url));
        config.spacing(0).enableSwipe(false).swipeHorizontal(false).scrollHandle(null).enableAntialiasing(true).enableAnnotationRendering(false);
        config.onLoad(new OnLoadCompleteListener(){

            public void loadComplete(int i) {
                PLogger.i(PanoPdfView.TAG, "pdf load completed " + i);
                PanoPdfView.this.mLoaded = true;
                PanoPdfView.this.mTotalPages = i;
                float[] pageSizes = new float[PanoPdfView.this.mTotalPages * 2];
                for (int idx = 0; idx < PanoPdfView.this.mTotalPages; ++idx) {
                    SizeF size = PanoPdfView.this.getPageSize(idx);
                    pageSizes[idx * 2] = size.getWidth();
                    pageSizes[idx * 2 + 1] = size.getHeight();
                }
                PanoPdfView.onLoadComplete(PanoPdfView.this.mNativeHandle, PanoPdfView.this.mShapeId, pageSizes);
                PanoPdfView.this.setOnTouchListener(null);
            }
        });
        config.onPageChange(new OnPageChangeListener(){

            public void onPageChanged(int i, int i1) {
            }
        });
        config.onPageScroll(new OnPageScrollListener(){

            public void onPageScrolled(int i, float v) {
            }
        });
        config.onError(new OnErrorListener(){

            public void onError(Throwable throwable) {
                PLogger.i(PanoPdfView.TAG, "onError " + throwable.getMessage() + "," + throwable.getLocalizedMessage());
            }
        });
        config.load();
    }

    public void snapshot(String filePath) {
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)viewWidth, (int)viewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        int cropY = 0;
        int cropX = 0;
        int cropW = viewWidth;
        int cropH = viewHeight;
        Bitmap ssBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)cropX, (int)cropY, (int)cropW, (int)cropH);
        try {
            File file = new File(filePath);
            ssBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)new FileOutputStream(file));
            PanoPdfView.onSnapshotComplete(this.mNativeHandle, this.mShapeId, filePath);
            PLogger.i(TAG, "snapshot complete " + filePath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static native void onLoadComplete(long var0, String var2, float[] var3);

    public static native void onSnapshotComplete(long var0, String var2, String var3);
}

