/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.api;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.pano.rtc.impl.PanoCoursePageFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import video.pano.rtc.impl.PLogger;

public class PanoWebView
extends WebView {
    private static final String TAG = "PanoWebView";
    private long mNativeHandle;
    private boolean mEnableTouchEvent = true;
    private int mContentWidth = 0;
    private int mContentHeight = 0;
    private int mParentWidth = 0;
    private int mParentHeight = 0;
    private float mScale = 1.0f;
    private float mTranslateX = 0.0f;
    private float mTranslateY = 0.0f;
    private String mPageId;

    public PanoWebView(Context context) {
        this(context, null);
    }

    public PanoWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setEnableTouchEvent(boolean enable) {
        this.mEnableTouchEvent = enable;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mEnableTouchEvent) {
            return super.onTouchEvent(event);
        }
        return true;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void init() {
        WebSettings webSettings = this.getSettings();
        webSettings.setSupportZoom(false);
        int textZoom = webSettings.getTextZoom();
        if (textZoom != 100) {
            webSettings.setTextZoom(100);
        }
        webSettings.setAllowFileAccessFromFileURLs(true);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setPluginState(WebSettings.PluginState.ON);
        webSettings.setUseWideViewPort(true);
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setDefaultTextEncodingName("utf-8");
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        webSettings.setSavePassword(false);
        webSettings.setAllowFileAccess(true);
        webSettings.setAppCacheEnabled(false);
        webSettings.setCacheMode(2);
        webSettings.setDomStorageEnabled(true);
        webSettings.setDatabaseEnabled(false);
        if (Build.VERSION.SDK_INT >= 19) {
            PanoWebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.setWebChromeClient(new WebChromeClient());
        this.setWebViewClient(new PanoWebViewClient());
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.addJavascriptInterface((Object)this, "android");
        PLogger.i(TAG, "init " + (Object)((Object)this));
    }

    public void enablePCUAForExternalHtml(boolean enable) {
        if (enable) {
            WebSettings webSettings = this.getSettings();
            String ua = webSettings.getUserAgentString();
            PLogger.i(TAG, "enablePCUAForExternalHtml default:" + ua);
            int leftBracket = ua.indexOf(40);
            int rightBracket = ua.indexOf(41);
            if (leftBracket != -1 && rightBracket != -1) {
                String newUA = ua.substring(0, leftBracket) + ua.substring(rightBracket + 1);
                PLogger.i(TAG, "enablePCUAForExternalHtml newUA:" + newUA);
                webSettings.setUserAgentString(newUA);
            } else {
                PLogger.w(TAG, "enablePCUAForExternalHtml set failed");
            }
        }
    }

    public void setPageId(String pageId) {
        this.mPageId = pageId;
    }

    public String getPageId() {
        return this.mPageId;
    }

    @JavascriptInterface
    public void resize(float height) {
        this.post(() -> {
            ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
            layoutParams.height = (int)(height + 0.5f);
        });
    }

    public void setNativeHandle(long nativeHandle) {
        this.mNativeHandle = nativeHandle;
    }

    public void close() {
        this.clearCache(true);
        this.clearHistory();
        this.destroy();
        PLogger.i(TAG, "close " + (Object)((Object)this));
    }

    public void scaleAtPoint(float scale, float pivotX, float pivotY) {
        this.setPivotX(0.0f);
        this.setPivotY(0.0f);
        this.setScaleX(scale);
        this.setScaleY(scale);
        this.setTranslationX(-pivotX);
        this.setTranslationY(-pivotY);
        this.mScale = scale;
        this.mTranslateX = -pivotX;
        this.mTranslateY = -pivotY;
    }

    public void move(float tx, float ty) {
        this.setTranslationX(tx);
        this.setTranslationY(ty);
        this.mTranslateX = tx;
        this.mTranslateY = ty;
    }

    public void snapshot(String filePath, boolean viewArea, int contentW, int contentH) {
        Bitmap ssBitmap;
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)viewWidth, (int)viewHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        this.draw(canvas);
        int cropY = 0;
        int cropX = 0;
        int cropW = viewWidth;
        int cropH = viewHeight;
        if (!viewArea) {
            if (contentW * viewHeight > contentH * viewWidth) {
                cropH = viewWidth * contentH / contentW;
                cropY = (viewHeight - cropH) / 2;
            } else {
                cropW = viewHeight * contentW / contentH;
                cropX = (viewWidth - cropW) / 2;
            }
            ssBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)cropX, (int)cropY, (int)cropW, (int)cropH);
        } else {
            float cx = (float)(this.mParentWidth - viewWidth) / 2.0f;
            float cy = (float)(this.mParentHeight - viewHeight) / 2.0f;
            cropX = (float)this.mParentWidth > (float)viewWidth * this.mScale ? 0 : (int)(-this.mTranslateX / this.mScale - cx / this.mScale);
            cropY = (float)this.mParentHeight > (float)viewHeight * this.mScale ? 0 : (int)(-this.mTranslateY / this.mScale - cy / this.mScale);
            cropW = Math.min((int)((float)this.mParentWidth / this.mScale), viewWidth);
            cropH = Math.min((int)((float)this.mParentHeight / this.mScale), viewHeight);
            ssBitmap = Bitmap.createBitmap((int)this.mParentWidth, (int)this.mParentHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas ssCanvas = new Canvas(ssBitmap);
            Paint paint = new Paint();
            ssCanvas.drawColor(Color.rgb((int)255, (int)255, (int)255));
            Rect src = new Rect(cropX, cropY, cropX + cropW, cropY + cropH);
            RectF dst = new RectF();
            float ox = ((float)this.mParentWidth - (float)viewWidth * this.mScale) / 2.0f;
            float oy = ((float)this.mParentHeight - (float)viewHeight * this.mScale) / 2.0f;
            dst.left = Math.max(ox, 0.0f);
            dst.top = Math.max(oy, 0.0f);
            dst.right = Math.min((float)this.mParentWidth - ox, (float)this.mParentWidth);
            dst.bottom = Math.min((float)this.mParentHeight - oy, (float)this.mParentHeight);
            ssCanvas.drawBitmap(bitmap, src, dst, paint);
        }
        try {
            File file = new File(filePath);
            ssBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)new FileOutputStream(file));
            PanoCoursePageFactory.onSnapshotComplete(this.mNativeHandle, this.mPageId, filePath);
        }
        catch (FileNotFoundException e) {
            PLogger.i(TAG, "snapshot " + e.getMessage() + "," + e.getLocalizedMessage());
        }
    }

    public void setContentSize(int width, int height) {
        this.mContentWidth = width;
        this.mContentHeight = height;
        PLogger.i(TAG, "setContentSize " + width + "," + height + "," + (Object)((Object)this));
    }

    public void adjustSize() {
        ViewGroup parent = (ViewGroup)this.getParent();
        int viewWidth = parent.getWidth();
        int viewHeight = parent.getHeight();
        this.mParentWidth = viewWidth;
        this.mParentHeight = viewHeight;
        PLogger.i(TAG, "adjustSize Thread :" + Thread.currentThread() + " before " + this.mParentWidth + "," + this.mParentHeight + (Object)((Object)this));
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)params;
            if (this.mContentWidth == 0 || this.mContentHeight == 0) {
                lp.width = viewWidth;
                lp.height = viewHeight;
                this.setLayoutParams((ViewGroup.LayoutParams)lp);
                PLogger.i(TAG, "adjustSize content " + lp.width + "," + lp.height + "," + (Object)((Object)this));
                return;
            }
            if (viewWidth * this.mContentHeight > viewHeight * this.mContentWidth) {
                lp.height = viewHeight;
                lp.width = viewHeight * this.mContentWidth / this.mContentHeight;
            } else {
                lp.width = viewWidth;
                lp.height = viewWidth * this.mContentHeight / this.mContentWidth;
            }
            lp.gravity = 17;
            this.setLayoutParams((ViewGroup.LayoutParams)lp);
            PLogger.i(TAG, "adjustSize after " + lp.width + "," + lp.height + "," + (Object)((Object)this));
        }
    }

    private class PanoWebViewClient
    extends WebViewClient {
        private PanoWebViewClient() {
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
            try {
                String urlDecode = new String(url.getBytes(), "UTF-8");
                urlDecode = URLDecoder.decode(urlDecode, "UTF-8");
                PLogger.i(PanoWebView.TAG, "urlDecode: " + urlDecode);
                if (PanoWebView.this.mNativeHandle != 0L && urlDecode.indexOf("pano_cw://") != -1) {
                    PanoCoursePageFactory.onUrlChange(PanoWebView.this.mNativeHandle, PanoWebView.this.mPageId, urlDecode);
                }
            }
            catch (UnsupportedEncodingException e) {
                PLogger.e(PanoWebView.TAG, "decode url(" + url + ") err : " + e.getMessage());
            }
            return super.shouldInterceptRequest(view, url);
        }

        public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
            return super.shouldInterceptRequest(view, request);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            PLogger.i(PanoWebView.TAG, "onPageStarted... " + url);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            PLogger.i(PanoWebView.TAG, "onPageFinished " + url);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            PLogger.i(PanoWebView.TAG, "onReceivedError1 errorCode : " + errorCode + " description : " + description + " failingUrl : " + failingUrl);
        }
    }
}

