/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.text.TextUtils;
import java.lang.reflect.Field;

public class Compatibility {
    private static boolean isCompatible(int apiLevel) {
        return Build.VERSION.SDK_INT >= apiLevel;
    }

    public static boolean isTabletScreen(Context ctxt) {
        boolean isTablet = false;
        if (!Compatibility.isCompatible(4)) {
            return false;
        }
        Configuration cfg = ctxt.getResources().getConfiguration();
        int screenLayoutVal = 0;
        try {
            Field f = Configuration.class.getDeclaredField("screenLayout");
            screenLayoutVal = (Integer)f.get(cfg);
        }
        catch (Exception e) {
            return false;
        }
        int screenLayout = screenLayoutVal & 0xF;
        if (screenLayout == 3 || screenLayout == 4) {
            isTablet = true;
        }
        return isTablet;
    }

    public static boolean runningOnEmulator() {
        if (!TextUtils.isEmpty((CharSequence)Build.MODEL) && Build.MODEL.toLowerCase().contains("sdk")) {
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)Build.MANUFACTURER) && Build.MANUFACTURER.toLowerCase().contains("unknown")) {
            return true;
        }
        return !TextUtils.isEmpty((CharSequence)Build.DEVICE) && Build.DEVICE.toLowerCase().contains("generic");
    }

    public static boolean runningOnGingerBreadOrHigher() {
        return Compatibility.isCompatible(9);
    }

    public static boolean runningOnJellyBeanOrHigher() {
        return Compatibility.isCompatible(16);
    }

    public static boolean runningOnJellyBeanMR1OrHigher() {
        return Compatibility.isCompatible(17);
    }

    public static boolean runningOnJellyBeanMR2OrHigher() {
        return Compatibility.isCompatible(18);
    }

    public static boolean runningOnKitkatOrHigher() {
        return Compatibility.isCompatible(19);
    }

    public static boolean runningOnKitkatWatchOrHigher() {
        return Compatibility.isCompatible(20);
    }

    public static boolean runningOnLollipopOrHigher() {
        return Compatibility.isCompatible(21);
    }

    public static boolean runningOnLollipopMR1OrHigher() {
        return Compatibility.isCompatible(22);
    }

    public static boolean runningOnMarshmallowOrHigher() {
        return Compatibility.isCompatible(23);
    }

    public static boolean runningOnNougatOrHigher() {
        return Compatibility.isCompatible(24);
    }

    public static boolean runningOnNougatMR1OrHigher() {
        return Compatibility.isCompatible(25);
    }

    public static boolean runningOnOreoOrHigher() {
        return Compatibility.isCompatible(26);
    }

    public static boolean runningOnOreoMR1OrHigher() {
        return Compatibility.isCompatible(27);
    }

    public static boolean runningOnPieOrHigher() {
        return Compatibility.isCompatible(28);
    }
}

