/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.base.util;

import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import video.pano.rtc.base.util.Compatibility;
import video.pano.rtc.impl.PLogger;

public class SystemPermissionUtils {
    private static final String[] PERMISSIONS = Build.VERSION.SDK_INT < 31 ? new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WAKE_LOCK", "android.permission.BLUETOOTH", "android.permission.MODIFY_AUDIO_SETTINGS"} : new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.ACCESS_WIFI_STATE", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.WAKE_LOCK", "android.permission.BLUETOOTH_CONNECT", "android.permission.MODIFY_AUDIO_SETTINGS"};

    public static boolean hasAudioOutputFeature(Context context) {
        return !Compatibility.runningOnLollipopOrHigher() || context.getPackageManager().hasSystemFeature("android.hardware.audio.output");
    }

    public static boolean hasMicrophoneFeature(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.microphone");
    }

    public static boolean checkAudioPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.RECORD_AUDIO");
    }

    public static boolean checkCameraPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.CAMERA");
    }

    public static boolean checkInternetPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.INTERNET");
    }

    public static boolean checkAccessNetworkStatePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.ACCESS_NETWORK_STATE");
    }

    public static boolean checkAccessWifiStatePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.ACCESS_WIFI_STATE");
    }

    public static boolean checkWriteExternalStoragePermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean checkWakeLockPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WAKE_LOCK");
    }

    public static boolean checkBluetoothPermission(Context context) {
        if (Build.VERSION.SDK_INT < 31) {
            return SystemPermissionUtils.checkPermission(context, "android.permission.BLUETOOTH");
        }
        return SystemPermissionUtils.checkPermission(context, "android.permission.BLUETOOTH_CONNECT");
    }

    public static boolean checkModifyAudioSettingsPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.MODIFY_AUDIO_SETTINGS");
    }

    public static boolean checkWriteSettingPermission(Context context) {
        return SystemPermissionUtils.checkPermission(context, "android.permission.WRITE_SETTINGS");
    }

    private static boolean checkPermission(Context context, String permission2) {
        return context.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    public static List<String> checkPermission(Context context) {
        ArrayList<String> list = new ArrayList<String>();
        for (String permission2 : PERMISSIONS) {
            if (SystemPermissionUtils.checkPermission(context, permission2)) continue;
            list.add(permission2);
        }
        return list;
    }

    public static void checkSelfPermission(Context context) {
        List<String> miss = SystemPermissionUtils.checkPermission(context);
        if (miss.isEmpty()) {
            PLogger.i("[pano]", "Permission is OK");
        } else {
            for (String permission2 : miss) {
                if (TextUtils.isEmpty((CharSequence)permission2)) continue;
                PLogger.e("[pano]", "Permission miss : " + permission2);
            }
        }
    }
}

