/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.impl.whiteboard;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import video.pano.rtc.impl.whiteboard.WBTextObject;

public class WBTextPopup
extends PopupWindow {
    private final Context mContext;
    private final EditText mEditText;
    private final WBTextObject mTextObject;
    private final Point mTextLocation = new Point();

    public WBTextPopup(Context context, int x, int y, WBTextObject textObject) {
        super(-2, -2);
        this.mContext = context;
        this.mTextObject = textObject;
        float uiTextSize = this.mTextObject.format.size;
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        if (metrics.density > 0.0f) {
            uiTextSize /= metrics.density;
        }
        this.mEditText = new EditText(context);
        this.mEditText.setBackground((Drawable)new ColorDrawable(0));
        this.mEditText.setHint((CharSequence)"please enter text");
        this.mEditText.setTextColor(this.mTextObject.format.color);
        this.mEditText.setTextSize(uiTextSize);
        this.mEditText.setText((CharSequence)this.mTextObject.text);
        this.mEditText.setEms(10);
        this.mEditText.setFocusable(true);
        this.mEditText.setImeOptions(6);
        this.mEditText.setInputType(131073);
        this.mEditText.setPadding(0, 0, 0, 0);
        this.mEditText.setOnFocusChangeListener((v, hasFocus) -> {
            if (hasFocus) {
                this.mEditText.postDelayed(() -> {
                    InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
                    if (imm != null) {
                        imm.showSoftInput((View)this.mEditText, 1);
                    }
                }, 200L);
            }
        });
        ViewTreeObserver vto = this.mEditText.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                WBTextPopup.this.mEditText.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int[] loc = new int[2];
                WBTextPopup.this.mEditText.getLocationOnScreen(loc);
                ((WBTextPopup)WBTextPopup.this).mTextLocation.x = loc[0];
                ((WBTextPopup)WBTextPopup.this).mTextLocation.y = loc[1];
            }
        });
        this.mEditText.requestFocus();
        this.setWidth(-2);
        this.setHeight(-2);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.setTouchable(true);
        this.setClippingEnabled(false);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setSoftInputMode(20);
        this.setAnimationStyle(0);
        this.setContentView((View)this.mEditText);
    }

    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        super.showAsDropDown(anchor, xoff, yoff, gravity);
    }

    public WBTextObject getTextObject() {
        if (this.mEditText != null && this.mTextObject != null) {
            this.mTextObject.setText(this.mEditText.getText().toString());
            int w = this.mEditText.getWidth();
            int h = this.mEditText.getHeight();
            int y = this.mTextLocation.y;
            this.mTextObject.setRect(this.mTextLocation.x, y, w, h);
        }
        return this.mTextObject;
    }
}

