/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.video;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageExtTransformFilter
extends GPUImageFilter {
    private static final String TAG = "GPUImageExtTransformFilter";
    public static final String EXT_TRANSFORM_VERTEX_SHADER = "attribute vec4 position;\n attribute vec4 inputTextureCoordinate;\n \n uniform mat4 transformMatrix;\n uniform mat4 orthographicMatrix;\n \n varying vec2 textureCoordinate;\n \n void main()\n {\n     gl_Position = transformMatrix * vec4(position.xyz, 1.0) * orthographicMatrix;\n     textureCoordinate = inputTextureCoordinate.xy;\n }";
    public static final String OES_NO_FILTER_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision highp float;varying highp vec2 textureCoordinate;\n \nuniform samplerExternalOES  inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    public static final int NOT_INIT = -2;
    public static final int ON_DRAWN = 1;
    private int[] mFrameBuffers = null;
    private int[] mFrameBufferTextures = null;
    private int mFrameWidth = -1;
    private int mFrameHeight = -1;
    private boolean ignoreAspectRatio = false;
    private int transformMatrixUniform;
    private int orthographicMatrixUniform;
    private float[] orthographicMatrix = new float[16];
    private float[] transform3D;
    private boolean anchorTopLeft = false;

    public GPUImageExtTransformFilter() {
        super(EXT_TRANSFORM_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
        this.loadOrthoMatrix(this.orthographicMatrix, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
        this.transform3D = new float[16];
        Matrix.setIdentityM((float[])this.transform3D, (int)0);
    }

    public GPUImageExtTransformFilter(String vertex, String fragment) {
        super(vertex, fragment);
        this.loadOrthoMatrix(this.orthographicMatrix, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
        this.transform3D = new float[16];
        Matrix.setIdentityM((float[])this.transform3D, (int)0);
    }

    public void onInit() {
        super.onInit();
        this.transformMatrixUniform = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"transformMatrix");
        this.orthographicMatrixUniform = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"orthographicMatrix");
    }

    public void onInitialized() {
        super.onInitialized();
        this.setUniformMatrix4f(this.transformMatrixUniform, this.transform3D);
        this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
    }

    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (!this.ignoreAspectRatio) {
            this.loadOrthoMatrix(this.orthographicMatrix, -1.0f, 1.0f, -1.0f * (float)height / (float)width, 1.0f * (float)height / (float)width, -1.0f, 1.0f);
            this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
        }
    }

    public void setTransform3D(float[] transform3D) {
        this.transform3D = transform3D;
        this.setUniformMatrix4f(this.transformMatrixUniform, transform3D);
    }

    public float[] getTransform3D() {
        return this.transform3D;
    }

    public void setIgnoreAspectRatio(boolean ignoreAspectRatio) {
        this.ignoreAspectRatio = ignoreAspectRatio;
        if (ignoreAspectRatio) {
            this.loadOrthoMatrix(this.orthographicMatrix, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f);
            this.setUniformMatrix4f(this.orthographicMatrixUniform, this.orthographicMatrix);
        } else {
            this.onOutputSizeChanged(this.getOutputWidth(), this.getOutputHeight());
        }
    }

    public boolean ignoreAspectRatio() {
        return this.ignoreAspectRatio;
    }

    public void setAnchorTopLeft(boolean anchorTopLeft) {
        this.anchorTopLeft = anchorTopLeft;
        this.setIgnoreAspectRatio(this.ignoreAspectRatio);
    }

    public boolean anchorTopLeft() {
        return this.anchorTopLeft;
    }

    private void loadOrthoMatrix(float[] matrix, float left, float right, float bottom, float top, float near, float far) {
        float r_l = right - left;
        float t_b = top - bottom;
        float f_n = far - near;
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        float scale = 2.0f;
        if (this.anchorTopLeft) {
            scale = 4.0f;
            tx = -1.0f;
            ty = -1.0f;
        }
        matrix[0] = scale / r_l;
        matrix[1] = 0.0f;
        matrix[2] = 0.0f;
        matrix[3] = tx;
        matrix[4] = 0.0f;
        matrix[5] = scale / t_b;
        matrix[6] = 0.0f;
        matrix[7] = ty;
        matrix[8] = 0.0f;
        matrix[9] = 0.0f;
        matrix[10] = scale / f_n;
        matrix[11] = tz;
        matrix[12] = 0.0f;
        matrix[13] = 0.0f;
        matrix[14] = 0.0f;
        matrix[15] = 1.0f;
    }

    public void initGPUImageInputFrameBuffer(int width, int height) {
        if (this.mFrameBuffers != null && (this.mFrameWidth != width || this.mFrameHeight != height)) {
            this.destroyFramebuffers();
        }
        if (this.mFrameBuffers == null) {
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            this.mFrameBuffers = new int[1];
            this.mFrameBufferTextures = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[0], (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
        this.mFrameWidth = -1;
        this.mFrameHeight = -1;
    }

    public int onDrawToTexture(int textureId, FloatBuffer vertexBuffer, FloatBuffer textureBuffer) {
        if (this.mFrameBuffers == null) {
            return -1;
        }
        FloatBuffer vertBuffer = vertexBuffer;
        GLES20.glClear((int)17664);
        if (!this.ignoreAspectRatio) {
            float[] adjustedVertices = new float[8];
            vertexBuffer.position(0);
            vertexBuffer.get(adjustedVertices);
            float normalizedHeight = (float)this.getOutputHeight() / (float)this.getOutputWidth();
            adjustedVertices[1] = adjustedVertices[1] * normalizedHeight;
            adjustedVertices[3] = adjustedVertices[3] * normalizedHeight;
            adjustedVertices[5] = adjustedVertices[5] * normalizedHeight;
            adjustedVertices[7] = adjustedVertices[7] * normalizedHeight;
            vertBuffer = ByteBuffer.allocateDirect(adjustedVertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertBuffer.put(adjustedVertices).position(0);
        }
        GLES20.glUseProgram((int)this.glProgId);
        this.runPendingOnDrawTasks();
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (!this.isInitialized()) {
            return -2;
        }
        vertBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)vertBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribTextureCoordinate);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)36197, (int)textureId);
            GLES20.glUniform1i((int)this.glUniformTexture, (int)0);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.glAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.glAttribTextureCoordinate);
        GLES20.glBindTexture((int)36197, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        return this.mFrameBufferTextures[0];
    }

    public int onDrawToFBO(int textureId, FloatBuffer vertexBuffer, FloatBuffer textureBuffer) {
        if (this.mFrameBuffers == null) {
            return -1;
        }
        FloatBuffer vertBuffer = vertexBuffer;
        GLES20.glClear((int)17664);
        if (!this.ignoreAspectRatio) {
            float[] adjustedVertices = new float[8];
            vertexBuffer.position(0);
            vertexBuffer.get(adjustedVertices);
            float normalizedHeight = (float)this.getOutputHeight() / (float)this.getOutputWidth();
            adjustedVertices[1] = adjustedVertices[1] * normalizedHeight;
            adjustedVertices[3] = adjustedVertices[3] * normalizedHeight;
            adjustedVertices[5] = adjustedVertices[5] * normalizedHeight;
            adjustedVertices[7] = adjustedVertices[7] * normalizedHeight;
            vertBuffer = ByteBuffer.allocateDirect(adjustedVertices.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
            vertBuffer.put(adjustedVertices).position(0);
        }
        GLES20.glUseProgram((int)this.glProgId);
        this.runPendingOnDrawTasks();
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GLES20.glClear((int)16384);
        if (!this.isInitialized()) {
            return -2;
        }
        vertBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)vertBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribTextureCoordinate);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)textureId);
            GLES20.glUniform1i((int)this.glUniformTexture, (int)0);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.glAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.glAttribTextureCoordinate);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        return this.mFrameBufferTextures[0];
    }

    public void onDestroy() {
        super.onDestroy();
        this.destroyFramebuffers();
    }
}

