/*
 * Decompiled with CFR 0.152.
 */
package video.pano.rtc.video;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageInput
extends GPUImageFilter {
    private static final String TAG = "GPUImageInput";
    public static final int NOT_INIT = -2;
    public static final int ON_DRAWN = 1;
    private final boolean mIsOESInput;
    private float[] mTextureTransformMatrix;
    private int mTextureTransformMatrixLocation;
    private int mSingleStepOffsetLocation;
    private int mParamsLocation;
    private int[] mFrameBuffers = null;
    private int[] mFrameBufferTextures = null;
    private int mFrameWidth = -1;
    private int mFrameHeight = -1;
    private int glProgId;
    public static float beautyLevel = 0.5f;

    public GPUImageInput(String vertex, String fragement, boolean isOESInput) {
        super(vertex, fragement);
        this.mIsOESInput = isOESInput;
    }

    public void onInit() {
        super.onInit();
        this.glProgId = super.getProgram();
        this.mTextureTransformMatrixLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"textureTransform");
        this.mSingleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
        this.mParamsLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"params");
        this.setBeautyLevel(beautyLevel);
    }

    public void setTextureTransformMatrix(float[] mtx) {
        this.mTextureTransformMatrix = mtx;
    }

    public void onDraw(int textureId, FloatBuffer vertexBuffer, FloatBuffer textureBuffer) {
        GLES20.glUseProgram((int)this.glProgId);
        this.runPendingOnDrawTasks();
        if (this.isInitialized()) {
            vertexBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.glAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)vertexBuffer);
            GLES20.glEnableVertexAttribArray((int)this.glAttribPosition);
            textureBuffer.position(0);
            GLES20.glVertexAttribPointer((int)this.glAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
            GLES20.glEnableVertexAttribArray((int)this.glAttribTextureCoordinate);
            GLES20.glUniformMatrix4fv((int)this.mTextureTransformMatrixLocation, (int)1, (boolean)false, (float[])this.mTextureTransformMatrix, (int)0);
            if (textureId != -1) {
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)(this.mIsOESInput ? 36197 : 3553), (int)textureId);
                GLES20.glUniform1i((int)this.glUniformTexture, (int)0);
            }
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glDisableVertexAttribArray((int)this.glAttribPosition);
            GLES20.glDisableVertexAttribArray((int)this.glAttribTextureCoordinate);
            GLES20.glBindTexture((int)(this.mIsOESInput ? 36197 : 3553), (int)0);
        }
    }

    public int onDrawToTexture(int textureId, FloatBuffer vertexBuffer, FloatBuffer textureBuffer) {
        if (this.mFrameBuffers == null) {
            return -1;
        }
        GLES20.glUseProgram((int)this.glProgId);
        this.runPendingOnDrawTasks();
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
        if (!this.isInitialized()) {
            return -2;
        }
        vertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)vertexBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribPosition);
        textureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.glAttribTextureCoordinate, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureBuffer);
        GLES20.glEnableVertexAttribArray((int)this.glAttribTextureCoordinate);
        GLES20.glUniformMatrix4fv((int)this.mTextureTransformMatrixLocation, (int)1, (boolean)false, (float[])this.mTextureTransformMatrix, (int)0);
        if (textureId != -1) {
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)(this.mIsOESInput ? 36197 : 3553), (int)textureId);
            GLES20.glUniform1i((int)this.glUniformTexture, (int)0);
        }
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.glAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.glAttribTextureCoordinate);
        GLES20.glBindTexture((int)(this.mIsOESInput ? 36197 : 3553), (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)this.mFrameWidth, (int)this.mFrameHeight);
        return this.mFrameBufferTextures[0];
    }

    public void initGPUImageInputFrameBuffer(int width, int height) {
        if (this.mFrameBuffers != null && (this.mFrameWidth != width || this.mFrameHeight != height)) {
            this.destroyFramebuffers();
        }
        if (this.mFrameBuffers == null) {
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            this.mFrameBuffers = new int[1];
            this.mFrameBufferTextures = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            GLES20.glGenTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextures[0]);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBuffers[0]);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextures[0], (int)0);
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public void destroyFramebuffers() {
        if (this.mFrameBufferTextures != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mFrameBufferTextures, (int)0);
            this.mFrameBufferTextures = null;
        }
        if (this.mFrameBuffers != null) {
            GLES20.glDeleteFramebuffers((int)1, (int[])this.mFrameBuffers, (int)0);
            this.mFrameBuffers = null;
        }
        this.mFrameWidth = -1;
        this.mFrameHeight = -1;
    }

    private void setTexelSize(float w, float h) {
        this.setFloatVec2(this.mSingleStepOffsetLocation, new float[]{2.0f / w, 2.0f / h});
    }

    public void onInputSizeChanged(int width, int height) {
        this.setTexelSize(width, height);
    }

    public void setBeautyLevel(float intensity) {
        this.setFloat(this.mParamsLocation, intensity);
    }

    public void onDestroy() {
        super.onDestroy();
        this.destroyFramebuffers();
    }

    public void onBeautyLevelChanged() {
        this.setBeautyLevel(beautyLevel);
    }
}

