/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageContrastFilter
extends GPUImageFilter {
    public static final String CONTRAST_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform lowp float contrast;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), textureColor.w);\n }";
    private int contrastLocation;
    private float contrast;

    public GPUImageContrastFilter() {
        this(1.2f);
    }

    public GPUImageContrastFilter(float contrast) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", CONTRAST_FRAGMENT_SHADER);
        this.contrast = contrast;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.contrastLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"contrast");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setContrast(this.contrast);
    }

    public void setContrast(float contrast) {
        this.contrast = contrast;
        this.setFloat(this.contrastLocation, this.contrast);
    }
}

