/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageGammaFilter
extends GPUImageFilter {
    public static final String GAMMA_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform lowp float gamma;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n }";
    private int gammaLocation;
    private float gamma;

    public GPUImageGammaFilter() {
        this(1.2f);
    }

    public GPUImageGammaFilter(float gamma) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", GAMMA_FRAGMENT_SHADER);
        this.gamma = gamma;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.gammaLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"gamma");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setGamma(this.gamma);
    }

    public void setGamma(float gamma) {
        this.gamma = gamma;
        this.setFloat(this.gammaLocation, this.gamma);
    }
}

