/*
 * Decompiled with CFR 0.152.
 */
package video.pano.android.gpuimage.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import video.pano.android.gpuimage.filter.GPUImageFilter;

public class GPUImageZoomBlurFilter
extends GPUImageFilter {
    public static final String ZOOM_BLUR_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform highp vec2 blurCenter;\nuniform highp float blurSize;\n\nvoid main()\n{\n    // TODO: Do a more intelligent scaling based on resolution here\n    highp vec2 samplingOffset = 1.0/100.0 * (blurCenter - textureCoordinate) * blurSize;\n    \n    lowp vec4 fragmentColor = texture2D(inputImageTexture, textureCoordinate) * 0.18;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate + samplingOffset) * 0.15;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate + (2.0 * samplingOffset)) *  0.12;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate + (3.0 * samplingOffset)) * 0.09;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate + (4.0 * samplingOffset)) * 0.05;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate - samplingOffset) * 0.15;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate - (2.0 * samplingOffset)) *  0.12;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate - (3.0 * samplingOffset)) * 0.09;\n    fragmentColor += texture2D(inputImageTexture, textureCoordinate - (4.0 * samplingOffset)) * 0.05;\n    \n    gl_FragColor = fragmentColor;\n}\n";
    private PointF blurCenter;
    private int blurCenterLocation;
    private float blurSize;
    private int blurSizeLocation;

    public GPUImageZoomBlurFilter() {
        this(new PointF(0.5f, 0.5f), 1.0f);
    }

    public GPUImageZoomBlurFilter(PointF blurCenter, float blurSize) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", ZOOM_BLUR_FRAGMENT_SHADER);
        this.blurCenter = blurCenter;
        this.blurSize = blurSize;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.blurCenterLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"blurCenter");
        this.blurSizeLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"blurSize");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setBlurCenter(this.blurCenter);
        this.setBlurSize(this.blurSize);
    }

    public void setBlurCenter(PointF blurCenter) {
        this.blurCenter = blurCenter;
        this.setPoint(this.blurCenterLocation, blurCenter);
    }

    public void setBlurSize(float blurSize) {
        this.blurSize = blurSize;
        this.setFloat(this.blurSizeLocation, blurSize);
    }
}

