/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import video.pano.AreaFocus;
import video.pano.Camera1Enumerator;
import video.pano.CameraEnumerationAndroid;
import video.pano.CameraSession;
import video.pano.CustomizedOrientation;
import video.pano.Histogram;
import video.pano.Logging;
import video.pano.NV21Buffer;
import video.pano.Size;
import video.pano.SurfaceTextureHelper;
import video.pano.TextureBufferImpl;
import video.pano.VideoFrame;

class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private int requestedFps;
    private long nextFrameTimestampNs;
    private SessionState state;
    private boolean firstFrameReported;
    private boolean mFlashModeTorchSupported;
    private AreaFocus mAreaFocus;
    private boolean mIsZoomSupported;
    private float mZoomValue;
    private float mMaxZoomValue;
    private int mZoomIndex;
    private float mExposureCompensationStep;
    private int mExposureCompensation;
    private int mMinExposureCompensation;
    private int mMaxExposureCompensation;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, int width, int height, int framerate) {
        CameraEnumerationAndroid.CaptureFormat captureFormat;
        Camera camera;
        long constructionTimeNs = System.nanoTime();
        Logging.d(TAG, "Open camera " + cameraId);
        events.onCameraOpening();
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + cameraId);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        try {
            Camera.Parameters parameters = camera.getParameters();
            captureFormat = Camera1Session.findClosestCaptureFormat(parameters, width, height, framerate);
            Size pictureSize = Camera1Session.findClosestPictureSize(parameters, width, height);
            Camera1Session.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
        }
        catch (RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (!captureToTexture) {
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                camera.addCallbackBuffer(buffer.array());
            }
        }
        camera.setDisplayOrientation(0);
        callback.onDone(new Camera1Session(events, captureToTexture, applicationContext, surfaceTextureHelper, cameraId, camera, info, captureFormat, constructionTimeNs, framerate));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        List focusModes = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (!captureToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + supportedFramerates);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(supportedFramerates, framerate);
        Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), width, height);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, previewSize);
        return new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
    }

    private Camera1Session(CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, int cameraId, Camera camera, Camera.CameraInfo info, CameraEnumerationAndroid.CaptureFormat captureFormat, long constructionTimeNs, int requestedFps) {
        Logging.d(TAG, "Create new camera1 session on camera " + cameraId);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = captureToTexture;
        this.applicationContext = applicationContext;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.camera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        this.requestedFps = requestedFps;
        surfaceTextureHelper.setTextureSize(captureFormat.width, captureFormat.height);
        this.startCapturing();
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera1StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    @Override
    public int setFlash(boolean flash) {
        Logging.d(TAG, "setFlash " + flash);
        if (this.mFlashModeTorchSupported) {
            this.cameraThreadHandler.post(() -> {
                Camera.Parameters param = this.getParametersSafe(this.camera);
                if (param == null) {
                    return;
                }
                List flashModes = param.getSupportedFlashModes();
                if (flashModes != null && flashModes.contains("torch")) {
                    param.setFlashMode(flash ? "torch" : "off");
                    try {
                        this.camera.setParameters(param);
                    }
                    catch (Exception e) {
                        Logging.w(TAG, "setFlash failed " + e);
                    }
                } else {
                    Logging.w(TAG, "setFlash failed: not supported torch flash");
                }
            });
            return 0;
        }
        return 2;
    }

    @Override
    public boolean isCameraFocusSupported() {
        if (this.camera != null) {
            try {
                Camera.Parameters parameters = this.camera.getParameters();
                List focusModes = parameters.getSupportedFocusModes();
                int maxNumFocusAreas = parameters.getMaxNumFocusAreas();
                if (focusModes.contains("auto") && maxNumFocusAreas > 0) {
                    return true;
                }
                Logging.e(TAG, "supportManualFocus false, maxNumFocusAreas : " + maxNumFocusAreas);
            }
            catch (Exception e) {
                Logging.e(TAG, "supportManualFocus err : " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void setFocusAreas(float x, float y) {
        Logging.d(TAG, "setFocusAreas {" + x + "," + y + "}");
        if (this.mAreaFocus == null) {
            this.mAreaFocus = new AreaFocus(this.applicationContext);
            this.mAreaFocus.setCamera(this.camera);
        }
        this.mAreaFocus.focusArea(x, y, 200, false);
    }

    @Override
    public boolean isCameraExposureSupported() {
        if (this.camera != null) {
            try {
                Camera.Parameters parameters = this.camera.getParameters();
                int maxNumMeteringAreas = parameters.getMaxNumMeteringAreas();
                if (maxNumMeteringAreas > 0) {
                    return true;
                }
                Logging.e(TAG, "supportManualExposure false, maxNumMeteringAreas : " + maxNumMeteringAreas);
            }
            catch (Exception e) {
                Logging.e(TAG, "supportManualExposure err : " + e.getMessage());
                return false;
            }
        }
        return false;
    }

    @Override
    public void setMeteringAreas(float x, float y) {
        Logging.d(TAG, "setMeteringAreas {" + x + "," + y + "}");
        if (this.mAreaFocus == null) {
            this.mAreaFocus = new AreaFocus(this.applicationContext);
            this.mAreaFocus.setCamera(this.camera);
        }
        this.mAreaFocus.focusArea(x, y, 200, true);
    }

    @Override
    public boolean isZoomSupported() {
        return this.mIsZoomSupported;
    }

    @Override
    public float getMaxZoom() {
        return this.mMaxZoomValue;
    }

    @Override
    public float getMinZoom() {
        return 1.0f;
    }

    @Override
    public void setZoom(float zoomValue) {
        Logging.d(TAG, "setZoom " + zoomValue);
        if (!this.mIsZoomSupported) {
            return;
        }
        this.cameraThreadHandler.post(() -> {
            try {
                Camera.Parameters param = this.getParametersSafe(this.camera);
                if (param == null) {
                    return;
                }
                List zoomRatios = param.getZoomRatios();
                if (param.isZoomSupported() && zoomRatios.size() > 1) {
                    int zoomIntValue = (int)(zoomValue * 100.0f);
                    int index = Collections.binarySearch(zoomRatios, zoomIntValue);
                    int targetIndex = 0;
                    targetIndex = index >= 0 ? index : (index == -1 * zoomRatios.size() - 1 ? zoomRatios.size() - 1 : -1 * index - 1);
                    if (targetIndex == this.mZoomIndex) {
                        return;
                    }
                    this.mZoomIndex = targetIndex;
                    this.mZoomValue = ((Integer)zoomRatios.get(targetIndex)).floatValue() / 100.0f;
                    param.setZoom(targetIndex);
                    try {
                        this.camera.setParameters(param);
                    }
                    catch (Exception e) {
                        Logging.w(TAG, "setZoom failed: " + e);
                    }
                } else {
                    Logging.w(TAG, "setZoom failed: not supported");
                }
            }
            catch (Exception e) {
                Logging.w(TAG, "setZoom failed: " + e);
                e.printStackTrace();
            }
        });
    }

    @Override
    public float getCurrentZoom() {
        return this.mZoomValue;
    }

    @Override
    public float getExposureCompensationStep() {
        return this.mExposureCompensationStep;
    }

    @Override
    public int getMinExposureCompensation() {
        return this.mMinExposureCompensation;
    }

    @Override
    public int getMaxExposureCompensation() {
        return this.mMaxExposureCompensation;
    }

    @Override
    public void setExposureCompensation(int value) {
        Logging.d(TAG, "SetExposureCompensation " + value);
        if (value < this.mMinExposureCompensation || value > this.mMaxExposureCompensation || value == this.mExposureCompensation) {
            return;
        }
        this.cameraThreadHandler.post(() -> {
            try {
                Camera.Parameters param = this.getParametersSafe(this.camera);
                if (param == null) {
                    return;
                }
                param.setExposureCompensation(value);
                try {
                    this.camera.setParameters(param);
                }
                catch (Exception e) {
                    Logging.w(TAG, "SetExposureCompensation param failed: " + e);
                }
                this.mExposureCompensation = value;
            }
            catch (Exception e) {
                Logging.w(TAG, "SetExposureCompensation failed: " + e);
                e.printStackTrace();
            }
        });
    }

    @Override
    public int getCurrentExposureCompensation() {
        return this.mExposureCompensation;
    }

    private Camera.Parameters getParametersSafe(Camera camera) {
        Camera.Parameters param = null;
        if (camera != null) {
            try {
                param = camera.getParameters();
            }
            catch (Exception e) {
                Logging.e(TAG, "getParametersSafe failed, " + e.getMessage());
            }
        }
        return param;
    }

    private void initCameraParameters() {
        this.mMaxZoomValue = 1.0f;
        this.mZoomValue = 1.0f;
        this.mZoomIndex = 0;
        this.mFlashModeTorchSupported = false;
        Camera.Parameters parameters = this.getParametersSafe(this.camera);
        if (parameters == null) {
            Logging.e(TAG, "initCameraParameters: getParametersSafe failed");
            return;
        }
        this.mIsZoomSupported = parameters.isZoomSupported();
        if (this.mIsZoomSupported) {
            int maxIndex = parameters.getMaxZoom();
            List zoomRatios = parameters.getZoomRatios();
            if (zoomRatios.size() <= 1 || zoomRatios.size() <= maxIndex) {
                this.mIsZoomSupported = false;
            } else {
                this.mMaxZoomValue = ((Integer)zoomRatios.get(maxIndex)).floatValue() / 100.0f;
            }
        }
        this.mMinExposureCompensation = parameters.getMinExposureCompensation();
        this.mMaxExposureCompensation = parameters.getMaxExposureCompensation();
        this.mExposureCompensationStep = parameters.getExposureCompensationStep();
        this.mExposureCompensation = this.mMinExposureCompensation - 1;
        List flashModes = parameters.getSupportedFlashModes();
        this.mFlashModeTorchSupported = flashModes != null && flashModes.contains("torch");
    }

    private void startCapturing() {
        Logging.d(TAG, "Start capturing");
        this.checkIsOnCameraThread();
        this.initCameraParameters();
        if (this.mAreaFocus != null) {
            this.mAreaFocus.setCamera(this.camera);
        }
        this.state = SessionState.RUNNING;
        this.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
                Logging.e(Camera1Session.TAG, errorMessage);
                Camera1Session.this.stopInternal();
                if (Thread.currentThread() != Camera1Session.this.cameraThreadHandler.getLooper().getThread()) {
                    Camera1Session.this.cameraThreadHandler.post(() -> {
                        if (error == 2) {
                            Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                        } else {
                            Camera1Session.this.events.onCameraError(Camera1Session.this, errorMessage);
                        }
                    });
                    return;
                }
                if (error == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, errorMessage);
                }
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
        }
        catch (RuntimeException e) {
            this.stopInternal();
            this.events.onCameraError(this, e.getMessage());
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        if (this.mAreaFocus != null) {
            this.mAreaFocus.destory();
            this.mAreaFocus = null;
        }
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            this.cameraThreadHandler.post(() -> this.stopInternal());
            return;
        }
        if (this.state == SessionState.STOPPED) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        this.camera.stopPreview();
        this.camera.setErrorCallback(null);
        this.camera.release();
        this.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private boolean keepFrame(long inputTimestampNs) {
        long timeUntilNextFrameNs;
        if (this.requestedFps == 0) {
            return true;
        }
        long frameIntervalNs = 1000000000L / (long)this.requestedFps;
        if (frameIntervalNs <= 0L) {
            return true;
        }
        if (this.nextFrameTimestampNs > 0L && Math.abs(timeUntilNextFrameNs = this.nextFrameTimestampNs - inputTimestampNs) < 2L * frameIntervalNs) {
            if (timeUntilNextFrameNs > 0L) {
                return false;
            }
            this.nextFrameTimestampNs += frameIntervalNs;
            return true;
        }
        this.nextFrameTimestampNs = inputTimestampNs + frameIntervalNs / 2L;
        return true;
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(frame -> {
            this.checkIsOnCameraThread();
            if (this.state != SessionState.RUNNING) {
                Logging.d(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs);
                camera1StartTimeMsHistogram.addSample(startTimeMs);
                this.firstFrameReported = true;
            }
            boolean mirror = false;
            if (CustomizedOrientation.getMirrorCorrection()) {
                mirror = this.info.facing == 1;
            }
            VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), mirror, 0), this.getFrameOrientation(), frame.getTimestampNs());
            if (!this.keepFrame(frame.getTimestampNs())) {
                modifiedFrame.release();
                return;
            }
            this.events.onFrameCaptured(this, modifiedFrame);
            modifiedFrame.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                Camera1Session.this.checkIsOnCameraThread();
                if (callbackCamera != Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(startTimeMs);
                    Camera1Session.this.firstFrameReported = true;
                }
                NV21Buffer frameBuffer = new NV21Buffer(data, ((Camera1Session)Camera1Session.this).captureFormat.width, ((Camera1Session)Camera1Session.this).captureFormat.height, () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(data);
                    }
                }));
                VideoFrame frame = new VideoFrame(frameBuffer, Camera1Session.this.getFrameOrientation(), captureTimeNs);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, frame);
                frame.release();
            }
        });
    }

    private int getFrameOrientation() {
        Integer customizedOrientation;
        int rotation = CameraSession.getDeviceOrientation(this.applicationContext);
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        if ((customizedOrientation = CustomizedOrientation.getDeviceOrientation(this.cameraId)) == null) {
            return (this.info.orientation + rotation) % 360;
        }
        return customizedOrientation % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

