/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.util.Range;
import android.util.Rational;
import android.view.Surface;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import video.pano.Camera2Enumerator;
import video.pano.CameraEnumerationAndroid;
import video.pano.CameraSession;
import video.pano.Histogram;
import video.pano.Logging;
import video.pano.Size;
import video.pano.SurfaceTextureHelper;
import video.pano.TextureBufferImpl;
import video.pano.VideoFrame;

@TargetApi(value=21)
class Camera2Session
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private CameraDevice cameraDevice;
    private Surface surface;
    private CameraCaptureSession captureSession;
    private CaptureRequest.Builder captureRequestBuilder;
    private CameraCaptureSession.CaptureCallback cameraCaptureCallback;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private long nextFrameTimestampNs;
    private final long constructionTimeNs;
    private boolean mIsZoomSupported;
    private float mZoomValue;
    private float mMaxZoomValue;
    private float mExposureCompensationStep;
    private int mExposureCompensation;
    private int mMinExposureCompensation;
    private int mMaxExposureCompensation;

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        new Camera2Session(callback, events, applicationContext, cameraManager, surfaceTextureHelper, cameraId, width, height, framerate);
    }

    private Camera2Session(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        Logging.d(TAG, "Create new camera2 session on camera " + cameraId);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = callback;
        this.events = events;
        this.applicationContext = applicationContext;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException e) {
            this.reportError("getCameraCharacteristics(): " + e.getMessage());
            return;
        }
        this.initCameraParameters();
        this.findCaptureFormat();
        this.openCamera();
    }

    private void initCameraParameters() {
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.mExposureCompensation = 0;
        Range exposureCompensationRange = (Range)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        this.mMaxExposureCompensation = (Integer)exposureCompensationRange.getUpper();
        this.mMinExposureCompensation = (Integer)exposureCompensationRange.getLower();
        this.mExposureCompensationStep = ((Rational)this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP)).floatValue();
        this.mMaxZoomValue = ((Float)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        if (Math.abs(this.mMaxZoomValue - 1.0f) > 0.01f) {
            this.mIsZoomSupported = true;
        }
        this.mZoomValue = 1.0f;
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Range[] fpsRanges = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(fpsRanges);
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> framerateRanges = Camera2Enumerator.convertFramerates(fpsRanges, this.fpsUnitFactor);
        List<Size> sizes = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + sizes);
        Logging.d(TAG, "Available fps ranges: " + framerateRanges);
        if (framerateRanges.isEmpty() || sizes.isEmpty()) {
            this.reportError("No supported capture formats.");
            return;
        }
        CameraEnumerationAndroid.CaptureFormat.FramerateRange bestFpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(framerateRanges, this.framerate);
        Size bestSize = CameraEnumerationAndroid.getClosestSupportedSize(sizes, this.width, this.height);
        CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, bestSize);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(bestSize.width, bestSize.height, bestFpsRange);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
    }

    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
        }
        catch (CameraAccessException e) {
            this.reportError("Failed to open camera: " + (Object)((Object)e));
            return;
        }
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera2StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    @Override
    public int setFlash(boolean flash) {
        return 0;
    }

    @Override
    public boolean isCameraFocusSupported() {
        return false;
    }

    @Override
    public void setFocusAreas(float x, float y) {
    }

    @Override
    public boolean isCameraExposureSupported() {
        return false;
    }

    @Override
    public void setMeteringAreas(float x, float y) {
    }

    @Override
    public boolean isZoomSupported() {
        return this.mIsZoomSupported;
    }

    @Override
    public float getMaxZoom() {
        return this.mMaxZoomValue;
    }

    @Override
    public float getMinZoom() {
        return 1.0f;
    }

    @Override
    public void setZoom(float zoomValue) {
        if (!this.mIsZoomSupported) {
            Logging.w(TAG, "setZoom failed: not supported");
            return;
        }
        this.cameraThreadHandler.post(() -> {
            try {
                if (this.captureSession == null) {
                    return;
                }
                float target = zoomValue > this.mMaxZoomValue ? this.mMaxZoomValue : zoomValue;
                float f = target = target < 1.0f ? 1.0f : target;
                if (Math.abs(target - this.mZoomValue) < 0.01f) {
                    return;
                }
                Rect m = (Rect)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
                int targetWidth = (int)((float)m.width() / target);
                int targetHeight = (int)((float)m.height() / target);
                if ((targetWidth & 3) != 0) {
                    targetWidth = targetWidth + 4 & 3;
                }
                if ((targetHeight & 3) != 0) {
                    targetHeight = targetHeight + 4 & 3;
                }
                int left = (m.width() - targetWidth) / 2;
                int top = (m.height() - targetHeight) / 2;
                Rect zoom = new Rect(left, top, left + targetWidth, top + targetHeight);
                this.captureRequestBuilder.set(CaptureRequest.SCALER_CROP_REGION, (Object)zoom);
                this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.cameraCaptureCallback, this.cameraThreadHandler);
                this.mZoomValue = target;
            }
            catch (Exception e) {
                Logging.w(TAG, "setZoom failed: " + e);
                e.printStackTrace();
            }
        });
    }

    @Override
    public float getCurrentZoom() {
        return this.mZoomValue;
    }

    @Override
    public float getExposureCompensationStep() {
        return this.mExposureCompensationStep;
    }

    @Override
    public int getMinExposureCompensation() {
        return this.mMinExposureCompensation;
    }

    @Override
    public int getMaxExposureCompensation() {
        return this.mMaxExposureCompensation;
    }

    @Override
    public void setExposureCompensation(int value) {
        this.cameraThreadHandler.post(() -> {
            try {
                if (this.captureSession == null) {
                    return;
                }
                int index = value > this.mMaxExposureCompensation ? this.mMaxExposureCompensation : value;
                int n = index = index < this.mMinExposureCompensation ? this.mMinExposureCompensation : index;
                if (index == this.mExposureCompensation) {
                    return;
                }
                this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, (Object)index);
                this.captureSession.setRepeatingRequest(this.captureRequestBuilder.build(), this.cameraCaptureCallback, this.cameraThreadHandler);
                this.mExposureCompensation = index;
            }
            catch (Exception e) {
                Logging.w(TAG, "setExposureCompensation failed: " + e);
                e.printStackTrace();
            }
        });
    }

    @Override
    public int getCurrentExposureCompensation() {
        return this.mExposureCompensation;
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    private void reportError(String error) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + error);
        boolean startFailure = this.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (startFailure) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, error);
        } else {
            this.events.onCameraError(this, error);
        }
    }

    private int getFrameOrientation() {
        int rotation = CameraSession.getDeviceOrientation(this.applicationContext);
        if (!this.isCameraFrontFacing) {
            rotation = 360 - rotation;
        }
        return (this.cameraOrientation + rotation) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private boolean keepFrame(long inputTimestampNs) {
        long timeUntilNextFrameNs;
        if (this.framerate == 0) {
            return true;
        }
        long frameIntervalNs = 1000000000L / (long)this.framerate;
        if (frameIntervalNs <= 0L) {
            return true;
        }
        if (this.nextFrameTimestampNs > 0L && Math.abs(timeUntilNextFrameNs = this.nextFrameTimestampNs - inputTimestampNs) < 2L * frameIntervalNs) {
            if (timeUntilNextFrameNs > 0L) {
                return false;
            }
            this.nextFrameTimestampNs += frameIntervalNs;
            return true;
        }
        this.nextFrameTimestampNs = inputTimestampNs + frameIntervalNs / 2L;
        return true;
    }

    private static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + failure);
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            session.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.this.captureSession = session;
            try {
                Camera2Session.this.captureRequestBuilder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                Camera2Session.this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                Camera2Session.this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                Camera2Session.this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                this.chooseStabilizationMode(Camera2Session.this.captureRequestBuilder);
                this.chooseFocusMode(Camera2Session.this.captureRequestBuilder);
                Camera2Session.this.captureRequestBuilder.addTarget(Camera2Session.this.surface);
                Camera2Session.this.cameraCaptureCallback = new CameraCaptureCallback();
                session.setRepeatingRequest(Camera2Session.this.captureRequestBuilder.build(), Camera2Session.this.cameraCaptureCallback, Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)e));
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(frame -> {
                Camera2Session.this.checkIsOnCameraThread();
                if (Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.this.firstFrameReported = true;
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs);
                    camera2StartTimeMsHistogram.addSample(startTimeMs);
                }
                VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), Camera2Session.this.isCameraFrontFacing, -Camera2Session.this.cameraOrientation), Camera2Session.this.getFrameOrientation(), frame.getTimestampNs());
                if (!Camera2Session.this.keepFrame(frame.getTimestampNs())) {
                    modifiedFrame.release();
                    return;
                }
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, modifiedFrame);
                modifiedFrame.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableVideoStabilization;
            int[] availableOpticalStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (availableOpticalStabilization != null) {
                for (int mode : availableOpticalStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            for (int mode : availableVideoStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) {
                if (mode != 1) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableFocusModes;
            for (int mode : availableFocusModes = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                if (mode != 3) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int errorCode) {
            switch (errorCode) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + errorCode;
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean startFailure = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.this.state = SessionState.STOPPED;
            Camera2Session.this.stopInternal();
            if (startFailure) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice camera, int errorCode) {
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.this.reportError(this.getErrorDescription(errorCode));
        }

        public void onOpened(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.this.cameraDevice = camera;
            Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            Camera2Session.this.surface = new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture());
            try {
                camera.createCaptureSession(Arrays.asList(Camera2Session.this.surface), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)e));
                return;
            }
        }

        public void onClosed(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

