/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import java.util.ArrayList;
import java.util.Arrays;
import video.pano.AndroidVideoDecoder;
import video.pano.EglBase;
import video.pano.Logging;
import video.pano.MediaCodecUtils;
import video.pano.MediaCodecWrapperFactoryImpl;
import video.pano.VideoCodecInfo;
import video.pano.VideoCodecType;
import video.pano.VideoDecoder;
import video.pano.VideoDecoderFactory;

class MediaCodecVideoDecoderFactory
implements VideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    private final EglBase.Context sharedContext;
    private final String[] prefixWhitelist;
    private final String[] prefixBlacklist;

    public MediaCodecVideoDecoderFactory(EglBase.Context sharedContext, String[] prefixWhitelist, String[] prefixBlacklist) {
        this.sharedContext = sharedContext;
        this.prefixWhitelist = Arrays.copyOf(prefixWhitelist, prefixWhitelist.length);
        this.prefixBlacklist = Arrays.copyOf(prefixBlacklist, prefixBlacklist.length);
    }

    @Override
    public VideoDecoder createDecoder(VideoCodecInfo codecType) {
        VideoCodecType type = VideoCodecType.valueOf(codecType.getName());
        MediaCodecInfo info = this.findCodecForType(type);
        if (info == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities capabilities = null;
        try {
            capabilities = info.getCapabilitiesForType(type.mimeType());
        }
        catch (IllegalArgumentException e) {
            Logging.e(TAG, "Cannot retrieve decoder capabilities", e);
        }
        if (capabilities == null) {
            return null;
        }
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), type, MediaCodecUtils.selectColorFormat(info.getName(), MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities), this.sharedContext);
    }

    @Override
    public VideoCodecInfo[] getSupportedCodecs() {
        ArrayList<VideoCodecInfo> supportedCodecInfos = new ArrayList<VideoCodecInfo>();
        for (VideoCodecType type : new VideoCodecType[]{VideoCodecType.VP8, VideoCodecType.VP9, VideoCodecType.H264}) {
            MediaCodecInfo codec = this.findCodecForType(type);
            if (codec == null) continue;
            String name = type.name();
            if (type == VideoCodecType.H264 && this.isH264HighProfileSupported(codec)) {
                supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, true)));
            }
            supportedCodecInfos.add(new VideoCodecInfo(name, MediaCodecUtils.getCodecProperties(type, false)));
        }
        return supportedCodecInfos.toArray(new VideoCodecInfo[supportedCodecInfos.size()]);
    }

    private MediaCodecInfo findCodecForType(VideoCodecType type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }
            if (info == null || info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, VideoCodecType type) {
        String name = info.getName();
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        MediaCodecInfo.CodecCapabilities capabilities = null;
        try {
            capabilities = info.getCapabilitiesForType(type.mimeType());
        }
        catch (IllegalArgumentException e) {
            Logging.e(TAG, "Cannot retrieve decoder capabilities", e);
        }
        if (capabilities == null) {
            return false;
        }
        if (MediaCodecUtils.selectColorFormat(name, MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities) == null) {
            return false;
        }
        return this.isWhitelisted(name) && !this.isBlacklisted(name);
    }

    private boolean isWhitelisted(String name) {
        for (String prefix : this.prefixWhitelist) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklisted(String name) {
        for (String prefix : this.prefixBlacklist) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        return Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.");
    }
}

