/*
 * Decompiled with CFR 0.152.
 */
package video.pano;

import android.content.Context;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import video.pano.CalledByNative;
import video.pano.ContextUtils;
import video.pano.Logging;
import video.pano.NetworkMonitorAutoDetect;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private final Object autoDetectLock = new Object();
    private NetworkMonitorAutoDetect autoDetect;
    private int numObservers = 0;
    private volatile NetworkMonitorAutoDetect.ConnectionType currentConnectionType;

    private NetworkMonitor() {
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
        this.currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;
    }

    @Deprecated
    public static void init(Context context) {
    }

    @CalledByNative
    public static NetworkMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private static void assertIsTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring(Context applicationContext) {
        Object object = this.autoDetectLock;
        synchronized (object) {
            ++this.numObservers;
            if (this.autoDetect == null) {
                this.autoDetect = this.createAutoDetect(applicationContext);
            }
            this.currentConnectionType = NetworkMonitorAutoDetect.getConnectionType(this.autoDetect.getCurrentNetworkState());
        }
    }

    @Deprecated
    public void startMonitoring() {
        this.startMonitoring(ContextUtils.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void startMonitoring(Context applicationContext, long nativeObserver) {
        Logging.d(TAG, "Start monitoring with native observer " + nativeObserver);
        this.startMonitoring(applicationContext != null ? applicationContext : ContextUtils.getApplicationContext());
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.add(nativeObserver);
        }
        this.updateObserverActiveNetworkList(nativeObserver);
        this.notifyObserversOfConnectionTypeChange(this.currentConnectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoring() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            if (--this.numObservers == 0) {
                this.autoDetect.destroy();
                this.autoDetect = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private void stopMonitoring(long nativeObserver) {
        Logging.d(TAG, "Stop monitoring with native observer " + nativeObserver);
        this.stopMonitoring();
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            this.nativeNetworkObservers.remove(nativeObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    private boolean networkBindingSupported() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect != null && this.autoDetect.supportNetworkCallback();
        }
    }

    @CalledByNative
    private static int androidSdkInt() {
        return Build.VERSION.SDK_INT;
    }

    public NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCurrentDefaultNetId() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect == null ? -1L : this.autoDetect.getDefaultNetId();
        }
    }

    private NetworkMonitorAutoDetect createAutoDetect(Context appContext) {
        return new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

            @Override
            public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
                NetworkMonitor.this.updateCurrentConnectionType(newConnectionType);
            }

            @Override
            public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
                NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInfo);
            }

            @Override
            public void onNetworkDisconnect(long networkHandle) {
                NetworkMonitor.this.notifyObserversOfNetworkDisconnect(networkHandle);
            }
        }, appContext);
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
        this.currentConnectionType = newConnectionType;
        this.notifyObserversOfConnectionTypeChange(newConnectionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType newConnectionType) {
        ArrayList<NetworkObserver> javaObservers;
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyConnectionTypeChanged(nativeObserver);
        }
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            javaObservers = new ArrayList<NetworkObserver>(this.networkObservers);
        }
        for (NetworkObserver observer : javaObservers) {
            observer.onConnectionTypeChanged(newConnectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInfo) {
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyOfNetworkConnect(nativeObserver, networkInfo);
        }
    }

    private void notifyObserversOfNetworkDisconnect(long networkHandle) {
        List<Long> nativeObservers = this.getNativeNetworkObserversSync();
        for (Long nativeObserver : nativeObservers) {
            this.nativeNotifyOfNetworkDisconnect(nativeObserver, networkHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateObserverActiveNetworkList(long nativeObserver) {
        List<NetworkMonitorAutoDetect.NetworkInformation> networkInfoList;
        Object object = this.autoDetectLock;
        synchronized (object) {
            networkInfoList = this.autoDetect == null ? null : this.autoDetect.getActiveNetworkList();
        }
        if (networkInfoList == null || networkInfoList.size() == 0) {
            return;
        }
        NetworkMonitorAutoDetect.NetworkInformation[] networkInfos = new NetworkMonitorAutoDetect.NetworkInformation[networkInfoList.size()];
        networkInfos = networkInfoList.toArray(networkInfos);
        this.nativeNotifyOfActiveNetworkList(nativeObserver, networkInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getNativeNetworkObserversSync() {
        ArrayList<Long> arrayList = this.nativeNetworkObservers;
        synchronized (arrayList) {
            return new ArrayList<Long>(this.nativeNetworkObservers);
        }
    }

    @Deprecated
    public static void addNetworkObserver(NetworkObserver observer) {
        NetworkMonitor.getInstance().addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.add(observer);
        }
    }

    @Deprecated
    public static void removeNetworkObserver(NetworkObserver observer) {
        NetworkMonitor.getInstance().removeObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(NetworkObserver observer) {
        ArrayList<NetworkObserver> arrayList = this.networkObservers;
        synchronized (arrayList) {
            this.networkObservers.remove(observer);
        }
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = NetworkMonitor.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, long var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NetworkMonitorAutoDetect getNetworkMonitorAutoDetect() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.autoDetect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumObservers() {
        Object object = this.autoDetectLock;
        synchronized (object) {
            return this.numObservers;
        }
    }

    static NetworkMonitorAutoDetect createAndSetAutoDetectForTest(Context context) {
        NetworkMonitorAutoDetect autoDetect;
        NetworkMonitor networkMonitor = NetworkMonitor.getInstance();
        networkMonitor.autoDetect = autoDetect = networkMonitor.createAutoDetect(context);
        return networkMonitor.autoDetect;
    }

    private static class InstanceHolder {
        static final NetworkMonitor instance = new NetworkMonitor();

        private InstanceHolder() {
        }
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

