/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CommonCipher {
    private String algorithm;
    private String mode;
    private String fillMode;
    private SecretKey secretKey;
    private PublicKey publicKey;
    private PrivateKey privateKey;

    public static CommonCipher RSA_ECB_PKCS1() {
        return new CommonCipher("RSA", "ECB", "PKCS1Padding");
    }

    public CommonCipher(String algorithm) {
        this.algorithm = algorithm;
    }

    public CommonCipher(String algorithm, String mode, String fillMode) {
        this.algorithm = algorithm;
        this.mode = mode;
        this.fillMode = fillMode;
    }

    public byte[] generateSymmetryKey() throws NoSuchAlgorithmException {
        this.secretKey = KeyGenerator.getInstance(this.algorithm).generateKey();
        return this.secretKey.getEncoded();
    }

    public KeyPairStore generatePairKey() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.algorithm);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.publicKey = keyPair.getPublic();
        this.privateKey = keyPair.getPrivate();
        KeyPairStore keyPairStore = new KeyPairStore(keyPair.getPublic().getEncoded(), keyPair.getPrivate().getEncoded());
        return keyPairStore;
    }

    public SecretKey loadSymmetryKey(byte[] keyBytes) {
        if (keyBytes == null) {
            return null;
        }
        if (keyBytes.length != 16) {
            return null;
        }
        this.secretKey = new SecretKeySpec(keyBytes, this.algorithm);
        return this.secretKey;
    }

    public PublicKey loadPublicKey(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        this.publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        return this.publicKey;
    }

    public PrivateKey loadPrivateKey(byte[] keyBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(this.algorithm);
        this.privateKey = keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        return this.privateKey;
    }

    public Cipher getInstance() throws NoSuchPaddingException, NoSuchAlgorithmException {
        String tmp = this.algorithm + (this.mode != null ? "/" + this.mode : "") + (this.fillMode != null ? "/" + this.fillMode : "");
        Cipher cipher = Cipher.getInstance(tmp);
        return cipher;
    }

    public Key checkKey(Key key) {
        if (key == null) {
            if (this.secretKey != null) {
                return this.secretKey;
            }
            if (this.publicKey != null) {
                return this.publicKey;
            }
            if (this.privateKey != null) {
                return this.privateKey;
            }
        }
        return key;
    }

    public byte[] encrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = this.getInstance();
        cipher.init(1, this.checkKey(key));
        return cipher.doFinal(data);
    }

    public byte[] encrypt(byte[] data) throws Exception {
        return this.encrypt(data, null);
    }

    public byte[] decrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = this.getInstance();
        cipher.init(2, this.checkKey(key));
        return cipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws Exception {
        return this.decrypt(data, null);
    }

    public class KeyPairStore {
        private byte[] publicKey;
        private byte[] privateKey;

        public KeyPairStore(byte[] publicKey, byte[] privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public byte[] getPublicKey() {
            return this.publicKey;
        }

        public void setPublicKey(byte[] publicKey) {
            this.publicKey = publicKey;
        }

        public byte[] getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(byte[] privateKey) {
            this.privateKey = privateKey;
        }
    }
}

