/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHttp {
    private static final Logger log = LoggerFactory.getLogger(CommonHttp.class);
    private static String serverIp = null;

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static String getServerIp() {
        if (serverIp == null) {
            serverIp = CommonHttp.isLinux() ? CommonHttp.getLinuxInetAddress() : CommonHttp.getLocalHostAddress();
        }
        return serverIp;
    }

    public static String getLinuxInetAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    InetAddress ia = address.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef!", (Throwable)e);
        }
        return null;
    }

    public static String getLocalHostAddress() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6\u670d\u52a1\u5668\u5730\u5740\u9519\u8bef!", (Throwable)e);
            return null;
        }
    }

    public static String getProxyHost(HttpServletRequest request) {
        return request.getHeader("x-forwarded-host");
    }
}

