/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common;

import vip.apicloud.common.CommonHttp;

public class CommonUUID {
    private long initTimestamp = 0L;
    private final long dataCenterIdBits = 5L;
    private final long maxDataCenterId = 31L;
    private final long workerIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long sequenceBits = 12L;
    private final long sequenceMask = 4095L;
    private long workerIdShift = 12L;
    private long dataCenterIdShift = 17L;
    private long timestampLeftShift = 22L;
    private long dataCenterId;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    public static final long DEFAULT_INIT_TIMESTAMP = 1262275200000L;

    public CommonUUID(long workerId, long dataCenterId, long initTimestamp) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.initTimestamp = initTimestamp;
    }

    public synchronized long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.initTimestamp << (int)this.timestampLeftShift | this.dataCenterId << (int)this.dataCenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    public static void main(String[] args) {
        CommonUUID generator = new CommonUUID(1L, 1L, 1262275200000L);
        for (int i = 0; i < 16; ++i) {
            System.out.println(generator.nextId());
        }
    }

    public static long getHashCodeId(String str) {
        int code = Math.abs(str.hashCode());
        return code % 32;
    }

    public static long getWorkerId() {
        String hostAddress = CommonHttp.getServerIp();
        return CommonUUID.getHashCodeId(hostAddress);
    }

    public static long getDataCenterId(String applicationName) {
        return CommonUUID.getHashCodeId(applicationName);
    }

    public static CommonUUID build(String applicationName) {
        return new CommonUUID(CommonUUID.getWorkerId(), CommonUUID.getDataCenterId(applicationName), 1262275200000L);
    }
}

