/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonUtil.class);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String STANDER_DATE_TEMPLATE = "yyyy-MM-dd";
    public static final String STANDER_TIME_TEMPLATE = "HH:mm:ss";
    public static final String STANDER_DATETIME_TEMPLATE = "yyyy-MM-dd HH:mm:ss";
    public static final String TEMP_PATH = System.getProperty("java.io.tmpdir") + File.separator;

    public static byte[] decodeBASE64(String src) {
        return BASE64.decode(src);
    }

    public static String decryptBASE64(String key) {
        return new String(BASE64.decode(key));
    }

    public static String encryptBASE64(byte[] src) {
        return BASE64.encode(src);
    }

    public static String generateSecretKey(String algorithm) {
        try {
            SecretKey secretKey = KeyGenerator.getInstance(algorithm).generateKey();
            return CommonUtil.encryptBASE64(secretKey.getEncoded());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static String decodeURL(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("[APICLOUD] decodeURL error!", (Throwable)e);
            return url;
        }
    }

    public static String encodeURL(String url) {
        if (url == null) {
            return null;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("[APICLOUD] decodeURL error!", (Throwable)e);
            return url;
        }
    }

    public static void writeToFile(byte[] bytes, String filepath) throws IOException {
        Files.write(Paths.get(filepath, new String[0]), bytes, new OpenOption[0]);
    }

    public static File bytesToFile(byte[] bytes, String outPath, String filename) throws IOException {
        String pathname = outPath + File.separator + filename;
        Files.write(Paths.get(pathname, new String[0]), bytes, new OpenOption[0]);
        return new File(pathname);
    }

    public static File bytesToFile(byte[] bytes, String filename) throws IOException {
        String pathname = TEMP_PATH + "TEMP_" + System.currentTimeMillis() + "_" + filename;
        Files.write(Paths.get(pathname, new String[0]), bytes, new OpenOption[0]);
        return new File(pathname);
    }

    public static InputStream bytesToInput(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static byte[] inputToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc = 0;
        while ((rc = inputStream.read(buff, 0, 1024)) > 0) {
            outputStream.write(buff, 0, rc);
        }
        inputStream.close();
        return outputStream.toByteArray();
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length);
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(0xFF & bytes[i]);
            if (temp.length() < 2) {
                sb.append(0);
            }
            sb.append(temp);
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hex) {
        int len = hex.length() / 2;
        hex = hex.toUpperCase();
        byte[] result = new byte[len];
        char[] chars = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(CommonUtil.toByte(chars[pos]) << 4 | CommonUtil.toByte(chars[pos + 1]));
        }
        return result;
    }

    private static byte toByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static Long toLong(String str) {
        return CommonUtil.isNumeric(str) ? Long.valueOf(str) : null;
    }

    public static int toInt(String str, int defaultValue) {
        return CommonUtil.isNumeric(str) ? Integer.parseInt(str) : defaultValue;
    }

    public static String format() {
        return CommonUtil.format(new Date());
    }

    public static String format(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDER_DATETIME_TEMPLATE);
        return simpleDateFormat.format(date);
    }

    public static String formatYMD(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STANDER_DATE_TEMPLATE);
        return simpleDateFormat.format(date);
    }

    public static String format(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static boolean isNumeric(String str) {
        return str != null && str.chars().allMatch(Character::isDigit);
    }

    public static boolean isExpired(String source) {
        return CommonUtil.isExpired(source, STANDER_DATE_TEMPLATE);
    }

    public static boolean isExpired(String source, String format) {
        String dStr = CommonUtil.format(new Date(), format);
        return source.compareTo(dStr) <= 0;
    }

    public static Date getLastDate(Date ... dates) {
        Date last = null;
        for (Date date : dates) {
            if (date == null) continue;
            if (last == null) {
                last = date;
                continue;
            }
            if (date.compareTo(last) <= 0) continue;
            last = date;
        }
        return null;
    }

    public static List<String> get7DayList() {
        ArrayList<String> list = new ArrayList<String>();
        Calendar today = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -7);
        while (calendar.before(today)) {
            calendar.add(5, 1);
            list.add(CommonUtil.formatYMD(calendar.getTime()));
        }
        return list;
    }

    public static String getPercent(int num1, int num2) {
        return CommonUtil.getPercent(num1, num2, "0.00");
    }

    public static String getPercent(int num1, int num2, String pattern) {
        return CommonUtil.getPercent(num1, num2, pattern, "%");
    }

    public static String getPercent(int num1, int num2, String pattern, String percent) {
        double rate = num2 == 0 ? 0.0 : (double)num1 / (double)num2 * 100.0;
        DecimalFormat df = new DecimalFormat(pattern);
        return df.format(rate) + (percent == null ? "" : percent);
    }

    public static class DATE {
        public static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        public static DateTimeFormatter ymdFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        public static DateTimeFormatter minFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        public static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public static String getHourAgo(long hours) {
            LocalDateTime localDateTime = LocalDateTime.now();
            return localDateTime.minusHours(hours).format(dateTimeFormatter);
        }

        public static String getHourAgo(Date date, long hours) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            return localDateTime.minusHours(hours).format(dateTimeFormatter);
        }

        public static LocalDateTime getHourAgo(LocalDateTime localDateTime, long hours) {
            return localDateTime.minusHours(hours);
        }

        public static String format(LocalDateTime localDateTime) {
            return localDateTime.format(dateTimeFormatter);
        }

        public static String format(Long timestamp) {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.ofHours(8));
            return DATE.format(localDateTime);
        }

        public static String formatMin(LocalDateTime localDateTime) {
            return localDateTime.format(minFormatter);
        }
    }

    public static class BASE64 {
        private static byte[] encodeBytes(byte[] src) {
            if (src.length == 0) {
                return src;
            }
            return Base64.getEncoder().encode(src);
        }

        private static byte[] decodeBytes(byte[] src) {
            if (src.length == 0) {
                return src;
            }
            return Base64.getDecoder().decode(src);
        }

        public static String encode(byte[] src) {
            if (src.length == 0) {
                return "";
            }
            return new String(BASE64.encodeBytes(src), DEFAULT_CHARSET);
        }

        public static byte[] decode(String src) {
            if (src.isEmpty()) {
                return new byte[0];
            }
            return BASE64.decodeBytes(src.getBytes(DEFAULT_CHARSET));
        }
    }
}

