/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.model;

import java.io.Serializable;
import java.util.List;
import vip.apicloud.common.model.ApiPage;
import vip.apicloud.common.model.HttpStatusCodeEnum;

public class ApiJson<T>
implements Serializable {
    private Integer code;
    private String msg;
    private T data;

    public Integer getCode() {
        return this.code;
    }

    public ApiJson setCode(Integer code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public ApiJson setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public ApiJson<T> setData(T data) {
        this.data = data;
        return this;
    }

    public ApiJson() {
    }

    public ApiJson(HttpStatusCodeEnum httpStatusCodeEnum) {
        this.code = httpStatusCodeEnum.getCode();
        this.msg = httpStatusCodeEnum.getMsg();
    }

    public ApiJson(HttpStatusCodeEnum httpStatusCodeEnum, T data) {
        this.code = httpStatusCodeEnum.getCode();
        this.msg = httpStatusCodeEnum.getMsg();
        this.data = data;
    }

    public ApiJson(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static ApiJson of(int code, String msg, Object object) {
        return new ApiJson<Object>(code, msg, object);
    }

    public static ApiJson ok() {
        return new ApiJson(HttpStatusCodeEnum.SC200);
    }

    public static ApiJson ok(String msg) {
        return new ApiJson<Object>(HttpStatusCodeEnum.SC200.getCode(), msg, null);
    }

    public static <T> ApiJson<T> ok(T data) {
        return new ApiJson<T>(HttpStatusCodeEnum.SC200, data);
    }

    public static <T> ApiJson<T> ok(String msg, T data) {
        return new ApiJson<T>(HttpStatusCodeEnum.SC200.getCode(), msg, data);
    }

    public static ApiJson error() {
        return new ApiJson(HttpStatusCodeEnum.SC500);
    }

    public static ApiJson error(String msg) {
        return new ApiJson<Object>(HttpStatusCodeEnum.SC500.getCode(), msg, null);
    }

    public static ApiJson error(Integer code, String msg) {
        return new ApiJson<Object>(code, msg, null);
    }

    public static <T> ApiJson<T> error(T data) {
        return new ApiJson<T>(HttpStatusCodeEnum.SC500, data);
    }

    public static <T> ApiJson<T> error(String msg, T data) {
        return new ApiJson<T>(HttpStatusCodeEnum.SC500.getCode(), msg, data);
    }

    public static <T> ApiJson page(List<T> list, long total) {
        return ApiJson.ok(new ApiPage<T>(list, total));
    }

    public static <T> ApiJson page(ApiPage<T> apiPage) {
        return ApiJson.ok(apiPage);
    }
}

