/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CommonByteBuf {
    public static byte[] byteBufToBytes(ByteBuf buf) {
        int length = buf.readableBytes();
        byte[] bytes = new byte[length];
        buf.readBytes(bytes);
        return bytes;
    }

    public static ByteBuf fileToByteBuf(File file) {
        try {
            FileInputStream input = new FileInputStream(file);
            return CommonByteBuf.fileToByteBuf(input);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ByteBuf fileToByteBuf(InputStream input) {
        try {
            ByteBuf byteBuf = Unpooled.buffer();
            byteBuf.writeBytes(CommonByteBuf.toByteArray(input));
            return byteBuf;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] toBytes(InputStream input) {
        byte[] bytes;
        try {
            bytes = CommonByteBuf.toByteArray(input);
        }
        catch (Exception e) {
            bytes = null;
        }
        return bytes == null ? new byte[]{} : bytes;
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((len = input.read(buffer)) > -1) {
            output.write(buffer, 0, len);
        }
        input.close();
        byte[] bytes = output.toByteArray();
        return bytes == null ? new byte[]{} : bytes;
    }
}

