/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vip.apicloud.common.netty.NamedThreadFactory;

public class CommonNetty {
    private static final Logger log = LoggerFactory.getLogger(CommonNetty.class);
    private static final DefaultHttpDataFactory FACTORY = new DefaultHttpDataFactory();

    public static boolean isEpollAvailable() {
        return Epoll.isAvailable();
    }

    public static EventLoopGroup getEventLoop(int size, String name) {
        if (CommonNetty.isEpollAvailable()) {
            return new EpollEventLoopGroup(size, (ThreadFactory)new NamedThreadFactory(name));
        }
        return new NioEventLoopGroup(size, (ThreadFactory)new NamedThreadFactory(name));
    }

    public static String getRequestPath(String uri) {
        QueryStringDecoder queryDecoder = new QueryStringDecoder(uri);
        return queryDecoder.path();
    }

    public static String getRequestPath(HttpRequest httpRequest) {
        QueryStringDecoder queryDecoder = new QueryStringDecoder(httpRequest.uri());
        return queryDecoder.path();
    }

    public static Map<String, String> getQueryParams(String uri) {
        QueryStringDecoder queryDecoder = new QueryStringDecoder(uri);
        Map parameters = queryDecoder.parameters();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        for (Map.Entry attr : parameters.entrySet()) {
            for (String attrVal : (List)attr.getValue()) {
                queryParams.put((String)attr.getKey(), attrVal);
            }
        }
        return queryParams;
    }

    public static Map<String, String> getQueryParams(HttpRequest httpRequest) {
        return CommonNetty.getQueryParams(httpRequest.uri());
    }

    public static String getCookieValue(HttpRequest request, String name) {
        String cookieOriginStr = request.headers().get("Cookie");
        if (cookieOriginStr == null) {
            return null;
        }
        Set cookies = ServerCookieDecoder.LAX.decode(cookieOriginStr);
        if (cookies.size() == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.name().equalsIgnoreCase(name)) continue;
            return cookie.value();
        }
        return null;
    }

    public static FullHttpResponse setContentType(FullHttpResponse fullHttpResponse, String contentType) {
        fullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        return fullHttpResponse;
    }

    public static String getContentType(HttpRequest httpRequest, String defaultContentType) {
        String contentType;
        if (httpRequest != null && (contentType = httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)) != null) {
            return contentType;
        }
        return defaultContentType;
    }

    public static String getContentType(HttpRequest httpRequest) {
        if (httpRequest == null) {
            return null;
        }
        return httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public static String getContentType(HttpHeaders headers) {
        return headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public static String getContentMime(HttpHeaders headers) {
        String contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType != null && contentType.contains(";")) {
            contentType = contentType.substring(0, contentType.indexOf(";")).trim();
        }
        return contentType;
    }

    public static Map<String, String> getPostData(FullHttpRequest req) {
        HashMap<String, String> bodyParams = new HashMap<String, String>();
        HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)FACTORY, (HttpRequest)req);
        List postData = decoder.getBodyHttpDatas();
        for (InterfaceHttpData data : postData) {
            if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            Attribute attribute = (Attribute)data;
            try {
                bodyParams.put(attribute.getName(), attribute.getValue());
            }
            catch (IOException e) {
                log.error("[APICLOUD] getPostData error!", (Throwable)e);
            }
        }
        decoder.destroy();
        return bodyParams;
    }

    public static String getClientHost(ChannelHandlerContext ctx) {
        String ip = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
        return ip != null && ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public static int getClientPort(ChannelHandlerContext ctx) {
        return ((InetSocketAddress)ctx.channel().remoteAddress()).getPort();
    }

    public static String getRemoteAddress(ChannelHandlerContext ctx) {
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        if (remoteAddress == null) {
            return null;
        }
        return remoteAddress.getAddress().getHostAddress();
    }
}

