/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpServer.class);
    private int port;
    private ServerBootstrap bootstrap;
    private List<ChannelHandler> childHandlers = new ArrayList<ChannelHandler>();

    public NettyHttpServer(int port) {
        this.port = port;
    }

    public NettyHttpServer(int port, ChannelHandler ... childHandler) {
        this.port = port;
        this.childHandlers = new ArrayList<ChannelHandler>(Arrays.asList(childHandler));
    }

    public void start() {
        this.start(null);
    }

    public void start(BootstrapInterface bootstrapInterface) {
        ChannelFuture future;
        Throwable cause;
        if (this.bootstrap == null) {
            this.build(bootstrapInterface);
        }
        if (null != (cause = (future = this.bootstrap.bind(this.port).awaitUninterruptibly()).cause())) {
            throw new RuntimeException("Could not start http server", cause);
        }
        log.debug("[APICLOUD] bootstrap run!");
    }

    public NettyHttpServer build(BootstrapInterface bootstrapInterface) {
        this.bootstrap = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            EpollEventLoopGroup bossGroup = new EpollEventLoopGroup();
            EpollEventLoopGroup workGroup = new EpollEventLoopGroup();
            this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(EpollServerSocketChannel.class);
        } else {
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            NioEventLoopGroup workGroup = new NioEventLoopGroup();
            this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class);
        }
        this.bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrap.handler((ChannelHandler)new LoggingHandler(LogLevel.INFO));
        this.childHandlers.forEach(childHandler -> this.bootstrap.childHandler(childHandler));
        if (bootstrapInterface != null) {
            bootstrapInterface.apply(this.bootstrap);
        }
        return this;
    }

    public NettyHttpServer childHandler(ChannelHandler childHandler) {
        this.childHandlers.add(childHandler);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ServerBootstrap getBootstrap() {
        return this.bootstrap;
    }

    @FunctionalInterface
    public static interface BootstrapInterface {
        public void apply(ServerBootstrap var1);
    }
}

