/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.spring;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SpringContext
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)applicationContext.getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)applicationContext.getBean(name, clazz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clazz) {
        return applicationContext.getBeansOfType(clazz);
    }

    public static <T extends Annotation> Map<Object, T> getBeansWithAnnotation(Class<T> annotationType) {
        LinkedHashMap map = new LinkedHashMap();
        if (applicationContext == null) {
            return map;
        }
        Map beans = applicationContext.getBeansWithAnnotation(annotationType);
        for (Map.Entry bean : beans.entrySet()) {
            Object beanObj = bean.getValue();
            map.put(beanObj, beanObj.getClass().getAnnotation(annotationType));
        }
        return map;
    }

    public static String getApplicationId() {
        return applicationContext.getId();
    }

    public static String getProperty(String key) {
        return applicationContext.getEnvironment().getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return applicationContext.getEnvironment().getProperty(key, defaultValue);
    }

    public static String getSysProperty(String key) {
        return applicationContext.getEnvironment().getProperty(SpringContext.checkPropertyKey(key));
    }

    public static String getSysProperty(String key, String defaultValue) {
        return applicationContext.getEnvironment().getProperty(SpringContext.checkPropertyKey(key), defaultValue);
    }

    private static String checkPropertyKey(String key) {
        return key.startsWith("apicloud.") ? key : "apicloud." + key;
    }
}

