/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.spring;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class SpringRestTemplate {
    private static final Logger log = LoggerFactory.getLogger(SpringRestTemplate.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String TEMP_PATH = System.getProperty("java.io.tmpdir") + File.separator;
    private static SimpleClientHttpRequestFactory FACTORY = new SimpleClientHttpRequestFactory();
    private static List<HttpMessageConverter<?>> messageConverters = new ArrayList();

    public static SimpleClientHttpRequestFactory factory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        return factory;
    }

    public static RestTemplate build(FactoryInterface factoryInterface) {
        RestTemplate restTemplate = new RestTemplate(messageConverters);
        SimpleClientHttpRequestFactory factory = SpringRestTemplate.factory();
        if (factoryInterface != null) {
            factoryInterface.setFactory(factory);
        }
        restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        return restTemplate;
    }

    public static RestTemplate build(SimpleClientHttpRequestFactory factory) {
        RestTemplate restTemplate = new RestTemplate();
        List httpMessageConverters = restTemplate.getMessageConverters();
        httpMessageConverters.forEach(httpMessageConverter -> {
            if (httpMessageConverter instanceof StringHttpMessageConverter) {
                StringHttpMessageConverter messageConverter = (StringHttpMessageConverter)httpMessageConverter;
                messageConverter.setDefaultCharset(Charset.forName("UTF-8"));
            }
        });
        if (factory != null) {
            restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        }
        return restTemplate;
    }

    public static String bytesToString(byte[] bytes, MediaType contentType) {
        Charset charset = SpringRestTemplate.getContentTypeCharset(contentType);
        return charset.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public static Charset getContentTypeCharset(MediaType contentType) {
        Charset charset;
        if (contentType != null) {
            charset = contentType.getCharset();
            if (charset != null) {
                return charset;
            }
            if (contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                return StandardCharsets.UTF_8;
            }
        }
        Assert.state(((charset = SpringRestTemplate.getDefaultCharset()) != null ? 1 : 0) != 0, (String)"No default charset");
        return charset;
    }

    public static Charset getDefaultCharset() {
        return DEFAULT_CHARSET;
    }

    static {
        FACTORY.setConnectTimeout(3000);
        FACTORY.setReadTimeout(30000);
        FACTORY.setBufferRequestBody(false);
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter(false));
    }

    @FunctionalInterface
    public static interface FactoryInterface {
        public void setFactory(SimpleClientHttpRequestFactory var1);
    }
}

