/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.common.spring.web;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.AbstractResource;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

public class SpringMultipartFileResource
extends AbstractResource {
    private final MultipartFile multipartFile;

    public SpringMultipartFileResource(MultipartFile multipartFile) {
        Assert.notNull((Object)multipartFile, (String)"MultipartFile must not be null");
        this.multipartFile = multipartFile;
    }

    public boolean exists() {
        return true;
    }

    public boolean isOpen() {
        return true;
    }

    public long contentLength() {
        return this.multipartFile.getSize();
    }

    public String getFilename() {
        return this.multipartFile.getOriginalFilename();
    }

    public InputStream getInputStream() throws IOException, IllegalStateException {
        return this.multipartFile.getInputStream();
    }

    public String getDescription() {
        return "MultipartFile resource [" + this.multipartFile.getName() + "]";
    }

    public int hashCode() {
        return this.multipartFile.hashCode();
    }
}

