/*
 * Decompiled with CFR 0.152.
 */
package vip.apicloud.oss.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.util.Pair;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import vip.apicloud.common.CommonUtil;
import vip.apicloud.common.spring.web.SpringByteArrayResource;
import vip.apicloud.common.spring.web.SpringInputStreamResource;
import vip.apicloud.common.spring.web.SpringMultipartFileResource;
import vip.apicloud.oss.client.OssProperties;
import vip.apicloud.oss.common.OssFileObject;

@Configuration
@ConditionalOnProperty(value={"apicloud.oss.server-url"})
@EnableConfigurationProperties(value={OssProperties.class})
public class OssFileClient {
    private RestTemplate restTemplate = new RestTemplate();
    private OssProperties ossProperties;

    public OssFileClient(OssProperties ossProperties) {
        this.ossProperties = ossProperties;
    }

    public OssFileObject upload(InputStream inputStream, long length, String filename) {
        SpringInputStreamResource resource = new SpringInputStreamResource(inputStream, length, filename);
        return this.upload((AbstractResource)resource, null);
    }

    public OssFileObject upload(MultipartFile multipartFile) {
        SpringMultipartFileResource resource = new SpringMultipartFileResource(multipartFile);
        return this.upload(resource, null);
    }

    public OssFileObject upload(File file) {
        FileSystemResource resource = new FileSystemResource(file);
        return this.upload((AbstractResource)resource, null);
    }

    public OssFileObject uploadTemp(InputStream inputStream, long length, String filename) {
        SpringInputStreamResource resource = new SpringInputStreamResource(inputStream, length, filename);
        return this.uploadFlag((AbstractResource)resource, "T");
    }

    public OssFileObject uploadTemp(MultipartFile multipartFile) {
        SpringMultipartFileResource resource = new SpringMultipartFileResource(multipartFile);
        return this.uploadFlag(resource, "T");
    }

    public OssFileObject uploadTemp(File file) {
        FileSystemResource resource = new FileSystemResource(file);
        return this.uploadFlag((AbstractResource)resource, "T");
    }

    public OssFileObject uploadFlag(AbstractResource resource, String flag) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("flag", "T");
        return this.upload(resource, params);
    }

    public OssFileObject upload(AbstractResource resource, Map<String, Object> params) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders requestHeaders = new HttpHeaders();
        requestHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"file", (Object)resource);
        if (params != null) {
            params.forEach((arg_0, arg_1) -> OssFileClient.lambda$upload$0((MultiValueMap)requestBody, arg_0, arg_1));
        }
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)requestHeaders);
        ResponseEntity responseEntity = restTemplate.postForEntity(this.ossProperties.uploadUrl(), (Object)requestEntity, OssFileObject.class, new Object[0]);
        if (responseEntity.getStatusCode().isError()) {
            return null;
        }
        return (OssFileObject)responseEntity.getBody();
    }

    public UrlResource resource(String url) throws Exception {
        return new UrlResource(this.ossProperties.resourceUrl(url));
    }

    public InputStream resourceInputStream(String url) throws Exception {
        UrlResource resource = new UrlResource(this.ossProperties.resourceUrl(url));
        return resource.getInputStream();
    }

    public Pair<byte[], String> downloadById(String id) {
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity responseEntity = restTemplate.getForEntity(this.ossProperties.downloadUrl(), byte[].class, new Object[]{id});
        if (responseEntity.getStatusCode().isError()) {
            return null;
        }
        ContentDisposition file = responseEntity.getHeaders().getContentDisposition();
        if (file.isAttachment()) {
            byte[] bytes = (byte[])responseEntity.getBody();
            String filename = file.getFilename() == null ? id : CommonUtil.decodeURL(file.getFilename());
            return new Pair((Object)bytes, (Object)filename);
        }
        return null;
    }

    public SpringByteArrayResource download(String id) {
        Pair<byte[], String> pair = this.downloadById(id);
        if (pair != null) {
            return new SpringByteArrayResource((byte[])pair.getKey(), (String)pair.getValue());
        }
        return null;
    }

    public File downloadFile(String id, String outPath) throws IOException {
        Pair<byte[], String> pair = this.downloadById(id);
        if (pair != null) {
            return CommonUtil.bytesToFile((byte[])pair.getKey(), outPath, (String)pair.getValue());
        }
        return null;
    }

    public File downloadFile(String id) throws IOException {
        Pair<byte[], String> pair = this.downloadById(id);
        if (pair != null) {
            return CommonUtil.bytesToFile((byte[])pair.getKey(), (String)pair.getValue());
        }
        return null;
    }

    private static /* synthetic */ void lambda$upload$0(MultiValueMap requestBody, String k, Object v) {
        requestBody.add((Object)k, v);
    }
}

