/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import vip.breakpoint.annotation.MParam;
import vip.breakpoint.exception.EasyExcelException;
import vip.breakpoint.utils.HSSFWorkbookUtils;
import vip.breakpoint.utils.ResponseUtils;

public abstract class ExcelDownloadUtils {
    public static <T> void downLoadExcelByCurrentData(HttpServletResponse response, List<T> data, String downFileName, String sheetName) throws IOException, EasyExcelException {
        ExcelDownloadUtils.downLoadExcelByCurrentData(response, data, downFileName, sheetName, false);
    }

    public static <T> void downLoadExcelByCurrentData(HttpServletResponse response, List<T> data, String downFileName, String sheetName, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould) throws IOException, EasyExcelException {
        if (null == data || data.size() == 0) {
            throw new EasyExcelException("\u4e0b\u8f7d\u7684\u6570\u636e\u4e0d\u80fd\u662f\u7a7a");
        }
        if (null == sheetName || "".equals(sheetName)) {
            throw new EasyExcelException("sheetName is empty");
        }
        ResponseUtils.preSetCommonHeader((HttpServletResponse)response);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            HSSFWorkbook hssfWorkbook = HSSFWorkbookUtils.getHSSFWorkbook(sheetName, data, isMould);
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(downFileName + ".xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)out);
        }
        catch (Exception e) {
            throw new EasyExcelException(e.getMessage());
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static <T> void downLoadExcelByCurrentData(HttpServletResponse response, Map<String, List<T>> dataMapVal, String downFileName) throws IOException, EasyExcelException {
        ExcelDownloadUtils.downLoadExcelByCurrentData(response, dataMapVal, downFileName, false);
    }

    public static <T> void downLoadExcelByCurrentData(HttpServletResponse response, Map<String, List<T>> dataMapVal, String downFileName, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould) throws IOException, EasyExcelException {
        if (null == dataMapVal || dataMapVal.size() == 0) {
            throw new EasyExcelException("\u4e0b\u8f7d\u7684\u6570\u636e\u4e0d\u80fd\u662f\u7a7a");
        }
        ResponseUtils.preSetCommonHeader((HttpServletResponse)response);
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            HSSFWorkbook hssfWorkbook = HSSFWorkbookUtils.getHSSFWorkbook(dataMapVal, isMould);
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(downFileName + ".xls", "UTF-8"));
            hssfWorkbook.write((OutputStream)out);
        }
        catch (Exception e) {
            throw new EasyExcelException(e.getMessage());
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }
}

