/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import vip.breakpoint.exception.EasyExcelException;
import vip.breakpoint.utils.HSSFWorkbookUtils;

public class ExcelWriteLocalStoreUtils {
    private static final String DEFAULT_SHEET_NAME = "sheet1";
    private static final String DEFAULT_FILE_SUFFIX = ".xls";

    public static <T> void writeJavaObjectToExcelFile(String absoluteStorePath, String fileName, String sheetName, List<T> data) throws EasyExcelException {
        if (null == data || data.size() <= 0) {
            return;
        }
        HSSFWorkbook hssfWorkbook = HSSFWorkbookUtils.getHSSFWorkbook(sheetName, data, false);
        String realFilePath = absoluteStorePath + File.separator + fileName + DEFAULT_FILE_SUFFIX;
        try {
            FileOutputStream out = new FileOutputStream(realFilePath);
            hssfWorkbook.write((OutputStream)out);
            out.close();
        }
        catch (IOException e) {
            throw new EasyExcelException(e.getMessage(), e);
        }
    }

    public static <T> void writeJavaObjectToExcelFile(String absoluteStorePath, String fileName, List<T> data) throws EasyExcelException {
        ExcelWriteLocalStoreUtils.writeJavaObjectToExcelFile(absoluteStorePath, fileName, DEFAULT_SHEET_NAME, data);
    }
}

