/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.utils;

import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddressList;
import vip.breakpoint.annotation.ExcelField;
import vip.breakpoint.annotation.MParam;
import vip.breakpoint.constants.EasyExcelConstants;
import vip.breakpoint.exception.EasyExcelException;
import vip.breakpoint.utils.ReflectUtils;

public class HSSFWorkbookUtils {
    private static final Short FONT_SIZE = EasyExcelConstants.FONT_SIZE;
    private static final String FONT_NAME = "\u6977\u4f53";
    private static final Short LINE_HEIGHT = EasyExcelConstants.LINE_HEIGHT;
    private static final Short MIN_SELECT_ROW_NUM = EasyExcelConstants.MIN_SELECT_ROW_NUM;
    private static final String HEADER_KEY = "header_key";

    public static <T> HSSFWorkbook getHSSFWorkbook(String sheetName, List<T> data, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould) throws EasyExcelException {
        if (null == data || data.size() == 0) {
            throw new EasyExcelException("\u6ca1\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5f97\u5230 HSSFWorkbook");
        }
        if (null == sheetName || "".equals(sheetName)) {
            throw new EasyExcelException("sheetName is empty");
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setDefaultRowHeightInPoints((float)LINE_HEIGHT.shortValue());
        sheet.setDefaultColumnWidth((int)LINE_HEIGHT.shortValue());
        HSSFFont font = workbook.createFont();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("General"));
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        cellStyle.setFont(font);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        HSSFWorkbookUtils.setSheetVal(sheet, data, isMould, cellStyle, font);
        return workbook;
    }

    public static <T> HSSFWorkbook getHSSFWorkbook(Map<String, List<T>> dataMapVal, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould) throws EasyExcelException {
        if (null == dataMapVal || dataMapVal.size() == 0) {
            throw new EasyExcelException("\u6ca1\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u5bfc\u51fa");
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFFont font = workbook.createFont();
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFDataFormat dataFormat = workbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("General"));
        font.setFontName(FONT_NAME);
        font.setFontHeightInPoints(FONT_SIZE.shortValue());
        cellStyle.setFont(font);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        for (Map.Entry<String, List<T>> entry : dataMapVal.entrySet()) {
            List<T> data = entry.getValue();
            HSSFSheet sheet = workbook.createSheet(entry.getKey());
            HSSFWorkbookUtils.setSheetVal(sheet, data, isMould, cellStyle, font);
        }
        return workbook;
    }

    private static <T> void setSheetVal(HSSFSheet sheet, List<T> data, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould, @MParam(value="\u5355\u5143\u683c\u7684\u683c\u5f0f") HSSFCellStyle cellStyle, HSSFFont font) throws EasyExcelException {
        int i;
        HSSFRow header = sheet.createRow(0);
        header.setHeightInPoints((float)LINE_HEIGHT.shortValue());
        Map<String, Object> headerData = HSSFWorkbookUtils.getDataMap(data.get(0), true, isMould);
        ArrayList headerTitle = (ArrayList)headerData.get(HEADER_KEY);
        short cellColor = isMould ? (short)10 : Short.MAX_VALUE;
        font.setColor(cellColor);
        HashMap<Integer, Integer> maxWith = new HashMap<Integer, Integer>();
        for (int i2 = 0; i2 < headerTitle.size(); ++i2) {
            sheet.setDefaultColumnStyle(i2, (CellStyle)cellStyle);
            HSSFCell cell = header.createCell(i2);
            HSSFWorkbookUtils.setCellValue(((ExcelField)headerTitle.get(i2)).name(), cell, i2, maxWith);
            if (((ExcelField)headerTitle.get(i2)).selectValues().length <= 0 || !isMould) continue;
            int lastRow = data.size() < MIN_SELECT_ROW_NUM ? MIN_SELECT_ROW_NUM.shortValue() : data.size();
            DataValidationHelper helper = sheet.getDataValidationHelper();
            DataValidationConstraint constraint = helper.createExplicitListConstraint(((ExcelField)headerTitle.get(i2)).selectValues());
            CellRangeAddressList addressList = new CellRangeAddressList(1, lastRow, i2, i2);
            DataValidation dataValidation = helper.createValidation(constraint, addressList);
            sheet.addValidationData(dataValidation);
        }
        HSSFRow row = sheet.createRow(1);
        row.setHeightInPoints((float)LINE_HEIGHT.shortValue());
        for (i = 0; i < headerTitle.size(); ++i) {
            Object cellData = headerData.get(((ExcelField)headerTitle.get(i)).name());
            HSSFCell cell = row.createCell(i);
            HSSFWorkbookUtils.setCellValue(cellData, cell, i, maxWith);
        }
        for (i = 1; i < data.size(); ++i) {
            HSSFRow innerRow = sheet.createRow(i + 1);
            innerRow.setHeightInPoints((float)LINE_HEIGHT.shortValue());
            Map<String, Object> dataMap = HSSFWorkbookUtils.getDataMap(data.get(i), false, isMould);
            for (int j = 0; j < headerTitle.size(); ++j) {
                Object cellData = dataMap.get(((ExcelField)headerTitle.get(j)).name());
                HSSFCell cell = innerRow.createCell(j);
                HSSFWorkbookUtils.setCellValue(cellData, cell, j, maxWith);
            }
        }
        for (i = 0; i < headerTitle.size(); ++i) {
            Integer width = (Integer)maxWith.get(i);
            sheet.setColumnWidth(i, (int)((double)width.intValue() * 1.5 * 256.0));
        }
    }

    private static void setCellValue(@MParam(value="\u6570\u636e\u4fe1\u606f") Object cellData, @MParam(value="\u5355\u5143\u683c") HSSFCell cell, int index, Map<Integer, Integer> maxWith) {
        String targetVal = null;
        if (cellData instanceof Integer) {
            targetVal = String.valueOf(cellData);
        } else if (cellData instanceof Long) {
            targetVal = String.valueOf(cellData);
        } else if (cellData instanceof Double) {
            targetVal = String.valueOf((double)Math.round((Double)cellData * 1000000.0) / 1000000.0);
        } else if (cellData instanceof Date) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            targetVal = sdf.format((Date)cellData);
        } else {
            targetVal = cellData instanceof String ? (String)cellData : String.valueOf(cellData);
        }
        if (null != targetVal && !"null".equals(targetVal)) {
            cell.setCellValue(targetVal);
        }
        try {
            maxWith.put(index, Math.max(maxWith.getOrDefault(index, 3), targetVal.getBytes("utf-8").length));
        }
        catch (Exception e) {
            maxWith.put(index, 0);
        }
    }

    private static <T> Map<String, Object> getDataMap(@MParam(value="\u8bf7\u6c42\u7684\u6570\u636e\u4fe1\u606f") T data, @MParam(value="\u8fd4\u56de\u7684\u7ed3\u679c\u91cc\u9762\u662f\u5426\u5177\u6709header\u4fe1\u606f") boolean isAttachHeaderMsg, @MParam(value="\u662f\u5426\u4e0b\u8f7d\u6a21\u7248") boolean isMould) throws EasyExcelException {
        TreeMap<String, Object> res = null;
        ArrayList<ExcelField> tempList = new ArrayList<ExcelField>();
        if (data != null) {
            res = new TreeMap<String, Object>();
            Class<?> clazz = data.getClass();
            List declaredFields = ReflectUtils.getFieldsFromClazz(clazz);
            if (declaredFields.size() > 0) {
                for (Field field : declaredFields) {
                    String key;
                    ExcelField annotation = field.getAnnotation(ExcelField.class);
                    if (null == annotation || "serialVersionUID".equals(key = field.getName())) continue;
                    if (!"".equals(annotation.name())) {
                        key = annotation.name();
                    }
                    if (annotation.isExplored()) {
                        if (!isMould || isMould && annotation.isMouldColumn()) {
                            tempList.add(annotation);
                        }
                    } else if (isMould && annotation.isMouldColumn()) {
                        tempList.add(annotation);
                    }
                    if (res.containsKey(key)) {
                        throw new EasyExcelException("\u5177\u6709\u76f8\u540c\u7684\u610f\u601d\u7684\u5c5e\u6027\uff0c\u4e0d\u6ee1\u8db3\u5355\u4e00\u6027");
                    }
                    try {
                        Object fieldValue = ReflectUtils.getFieldValueFromObj((Field)field, data);
                        if (null == fieldValue) continue;
                        if (fieldValue instanceof Date) {
                            String pattern = annotation.datePattern();
                            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
                            res.put(key, sdf.format(fieldValue));
                            continue;
                        }
                        if (fieldValue instanceof Boolean) {
                            String targetVal = (Boolean)fieldValue != false ? "true" : "false";
                            res.put(key, targetVal);
                            continue;
                        }
                        res.put(key, fieldValue);
                    }
                    catch (Exception e) {}
                }
            }
        }
        if (res != null && isAttachHeaderMsg && !res.containsKey(HEADER_KEY)) {
            res.put(HEADER_KEY, HSSFWorkbookUtils.getSortedRes(tempList));
        }
        return res;
    }

    private static List<ExcelField> getSortedRes(List<ExcelField> origin) {
        ExcelField[] excelFields = origin.toArray(new ExcelField[0]);
        for (int i = 0; i < excelFields.length; ++i) {
            for (int j = i; j < excelFields.length; ++j) {
                if (excelFields[i].order() <= excelFields[j].order()) continue;
                ExcelField temp = excelFields[i];
                excelFields[i] = excelFields[j];
                excelFields[j] = temp;
            }
        }
        ArrayList<ExcelField> res = new ArrayList<ExcelField>();
        for (ExcelField field : excelFields) {
            res.add(field);
        }
        return res;
    }
}

