/*
 * Decompiled with CFR 0.152.
 */
package vip.breakpoint.utils;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import vip.breakpoint.annotation.ExcelField;
import vip.breakpoint.annotation.MParam;
import vip.breakpoint.exception.EasyExcelException;
import vip.breakpoint.exception.EasyToolException;
import vip.breakpoint.utils.EasyDateUtils;
import vip.breakpoint.utils.ExcelJavaTypeUtils;
import vip.breakpoint.utils.ReflectUtils;

public class ParseExcelInputStreamUtils {
    public static <T> Map<String, List<T>> getDataMapFromCurrentInput(@MParam(value="\u6587\u4ef6\u6d41\u7684\u4fe1\u606f") InputStream inputStream, @MParam(value="\u7c7b\u4fe1\u606f") Map<String, Class<? extends T>> clazzMap) throws EasyExcelException {
        try {
            Workbook sheets = WorkbookFactory.create((InputStream)inputStream);
            HashMap<String, List<T>> res = new HashMap<String, List<T>>();
            for (Map.Entry<String, Class<T>> entry : clazzMap.entrySet()) {
                Sheet sheet = sheets.getSheet(entry.getKey());
                if (null == sheet) {
                    throw new EasyExcelException("\u6ca1\u6709\u5bf9\u5e94\u7684 sheet \u7b49\u4e8e" + entry.getKey() + ",\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6587\u4ef6");
                }
                res.put(entry.getKey(), ParseExcelInputStreamUtils.getDataList(sheet, entry.getValue()));
            }
            Sheet sheetAt = sheets.getSheetAt(0);
            return res;
        }
        catch (IOException e) {
            throw new EasyExcelException("\u89e3\u6790\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25 e={" + e.getMessage() + "}");
        }
    }

    public static <T> List<T> getDataList(@MParam(value="\u8f93\u5165\u6d41") InputStream inputStream, @MParam(value="\u8fd4\u56de\u7684\u6570\u636e\u7684\u7c7b\u578b") Class<? extends T> clazz) throws EasyExcelException {
        try {
            Workbook sheets = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheetAt = sheets.getSheetAt(0);
            return ParseExcelInputStreamUtils.getDataList(sheetAt, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new EasyExcelException("\u89e3\u6790\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25 e={" + e.getMessage() + "}");
        }
    }

    private static <T> List<T> getDataList(Sheet sheet, Class<? extends T> clazz) throws EasyExcelException {
        ArrayList<T> res = new ArrayList<T>();
        List<String> fields = null;
        if (null != sheet) {
            for (Row row : sheet) {
                if (row.getRowNum() == 0) {
                    if (null != fields) continue;
                    fields = ParseExcelInputStreamUtils.getTitleMethodList(row);
                    continue;
                }
                try {
                    T data = ParseExcelInputStreamUtils.getDataFromRow(row, clazz, fields);
                    res.add(data);
                }
                catch (EasyExcelException e) {
                    throw new EasyExcelException(e.getMessage());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return res;
    }

    private static <T> T getDataFromRow(Row row, Class<? extends T> clazz, List<String> fields) throws EasyExcelException {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        for (int i = 0; i < fields.size(); ++i) {
            valMap.put(fields.get(i), ParseExcelInputStreamUtils.getRealVal(row.getCell(i)));
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            T res = constructor.newInstance(new Object[0]);
            List declaredFields = ReflectUtils.getFieldsFromClazz(clazz);
            if (declaredFields.size() > 0) {
                for (Field field : declaredFields) {
                    String key;
                    Object oriValue;
                    ExcelField annotation = field.getAnnotation(ExcelField.class);
                    if (annotation == null || !annotation.isMouldColumn() || null == (oriValue = valMap.get(key = annotation.name()))) continue;
                    Class<?> type = field.getType();
                    Object value = null;
                    if (type == Integer.class || type == Integer.TYPE) {
                        value = ExcelJavaTypeUtils.getTargetValue(oriValue, Integer.class);
                    }
                    if (type == Long.class || type == Long.TYPE) {
                        value = ExcelJavaTypeUtils.getTargetValue(oriValue, Long.class);
                    }
                    if (type == Double.class || type == Double.TYPE) {
                        value = ExcelJavaTypeUtils.getTargetValue(oriValue, Double.class);
                    }
                    if (type == String.class) {
                        String targetVal = null;
                        if (annotation.selectValues().length > 0) {
                            HashSet<String> allSelectValue;
                            targetVal = (String)valMap.get(key);
                            if (annotation.selectValues().length > 0 && !(allSelectValue = new HashSet<String>(Arrays.asList(annotation.selectValues()))).contains(targetVal)) {
                                throw new EasyExcelException("\u8bf7\u4e0b\u62c9\u9009\u62e9excel\u8868\u4e2d\u7684" + key + "\u5217\u7684\u6570\u636e");
                            }
                        }
                        if (valMap.get(key) instanceof Double) {
                            BigDecimal bigDecimal = new BigDecimal((Double)valMap.get(key));
                            targetVal = bigDecimal.toPlainString();
                        } else {
                            targetVal = (String)valMap.get(key);
                        }
                        value = targetVal;
                    }
                    if (type == Date.class) {
                        Object val = valMap.get(key);
                        if (val instanceof Date) {
                            value = val;
                        } else {
                            try {
                                value = EasyDateUtils.parseDateStr((String)((String)val));
                            }
                            catch (EasyToolException e) {
                                throw new EasyExcelException(e.getMessage());
                            }
                        }
                    }
                    ReflectUtils.setFieldValue2Object((Field)field, res, (Object)value);
                }
            }
            return res;
        }
        catch (NoSuchMethodException e) {
            throw new EasyExcelException("\u8bf7\u4fdd\u7559\u65e0\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e2) {
            e2.printStackTrace();
            throw new EasyExcelException("\u521b\u5efa\u65b0\u7684\u5bf9\u8c61\u5931\u8d25");
        }
    }

    private static <T> List<String> getTitleMethodList(Row row) throws EasyExcelException {
        String key;
        int lastCellNum = row.getLastCellNum();
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < lastCellNum && null != (key = row.getCell(i).getStringCellValue()) && !"".equals(key); ++i) {
            if (res.contains(key)) {
                throw new EasyExcelException("\u5177\u6709\u76f8\u540c\u7684\u610f\u601d\u7684\u5c5e\u6027\uff0c\u4e0d\u6ee1\u8db3\u5355\u4e00\u6027");
            }
            res.add(key);
        }
        return res;
    }

    private static Object getRealVal(Cell cell) {
        if (null == cell) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (!"General".equals(cell.getCellStyle().getDataFormatString())) {
                    return cell.getDateCellValue();
                }
                return cell.getNumericCellValue();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }
}

