/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.MessageListenerAdapter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import vip.justlive.rabbit.annotation.Rqueue;
import vip.justlive.rabbit.consumer.Consumer;
import vip.justlive.rabbit.consumer.ConsumerDef;
import vip.justlive.rabbit.consumer.Receiver;

@ConditionalOnProperty(name={"spring.rabbitmq.listener.enabled"}, havingValue="true")
public class RabbitConsumerAutoConfiguration
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(RabbitConsumerAutoConfiguration.class);
    private Environment environment;

    @Bean
    @ConditionalOnBean(value={MessageConverter.class})
    public Receiver simpleMessageReceiver(MessageConverter converter) {
        log.info("init receiver with converter [{}]", (Object)converter);
        return new Receiver(converter);
    }

    @Bean
    @ConditionalOnBean(value={ConnectionFactory.class, AmqpAdmin.class, Receiver.class})
    @ConfigurationProperties(prefix="spring.rabbitmq.listener.simple")
    public SimpleMessageListenerContainer simpleMessageListenerContainer(ConnectionFactory connectionFactory, AmqpAdmin amqpAdmin, Receiver receiver, @Autowired(required=false) List<Consumer<?>> list) {
        HashSet<String> queueNames = new HashSet<String>();
        SimpleMessageListenerContainer container = new SimpleMessageListenerContainer(connectionFactory);
        this.init(list, amqpAdmin, queueNames);
        container.setMessageListener((MessageListener)new MessageListenerAdapter((Object)receiver));
        container.setQueueNames(queueNames.toArray(new String[0]));
        container.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        log.info("init message listener for queue(s) {}", queueNames);
        return container;
    }

    private void init(List<Consumer<?>> list, AmqpAdmin amqpAdmin, Set<String> queueNames) {
        if (list == null || list.isEmpty()) {
            log.warn("not found MessageProcess");
            return;
        }
        for (Consumer<?> consumer : list) {
            Rqueue rqueue = consumer.getClass().getAnnotation(Rqueue.class);
            if (rqueue == null) {
                log.warn("{} should be annotated by @Rqueue", consumer);
                continue;
            }
            String queueName = this.environment.resolvePlaceholders(rqueue.queue());
            String exchangeName = this.environment.resolvePlaceholders(rqueue.exchange());
            String exchangeType = this.environment.resolvePlaceholders(rqueue.exchangeType());
            String routing = this.environment.resolvePlaceholders(rqueue.routing());
            String messageConverter = this.environment.resolvePlaceholders(rqueue.messageConverter());
            Queue queue = new Queue(queueName);
            amqpAdmin.declareQueue(queue);
            queueNames.add(queueName);
            if (StringUtils.hasText((String)exchangeName)) {
                Exchange exchange = new ExchangeBuilder(exchangeName, exchangeType).build();
                amqpAdmin.declareExchange(exchange);
                amqpAdmin.declareBinding(BindingBuilder.bind((Queue)queue).to(exchange).with(routing).noargs());
            }
            log.info("register consumer for [{}][{}][{}] using [{}][{}]", new Object[]{queueName, exchangeName, routing, messageConverter, consumer});
            ConsumerDef.register(queueName, exchangeName, routing, messageConverter, consumer);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

