/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.consumer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import vip.justlive.rabbit.consumer.Consumer;
import vip.justlive.rabbit.producer.QueueProperties;

public class ConsumerDef
implements Consumer<Object> {
    private static final Map<String, ConsumerDef> CONSUMERS = new HashMap<String, ConsumerDef>(4);
    private final QueueProperties queueProperties;
    private final Consumer<Object> delegate;
    private Type type;

    private ConsumerDef(QueueProperties queueProperties, Consumer<?> delegate) {
        this.queueProperties = queueProperties;
        this.delegate = delegate;
    }

    @Override
    public void accept(Object msg) {
        this.delegate.accept(msg);
    }

    public Type getType() {
        Type[] types;
        if (this.type != null) {
            return this.type;
        }
        for (Type t : types = this.delegate.getClass().getGenericInterfaces()) {
            ParameterizedType tt;
            if (!(t instanceof ParameterizedType) || (tt = (ParameterizedType)t).getRawType() != Consumer.class) continue;
            this.type = tt.getActualTypeArguments()[0];
            break;
        }
        return this.type;
    }

    public static void register(String queue, String exchange, String routing, String messageConverter, Consumer<?> delegate) {
        QueueProperties queueProperties = new QueueProperties(queue, exchange, routing, messageConverter);
        CONSUMERS.put(ConsumerDef.key(queue, exchange, routing), new ConsumerDef(queueProperties, delegate));
    }

    public static ConsumerDef lookup(String queue, String exchange, String routing) {
        return CONSUMERS.get(ConsumerDef.key(queue, exchange, routing));
    }

    private static String key(String queue, String exchange, String routing) {
        return String.join((CharSequence)"|", queue, exchange, routing);
    }

    public QueueProperties getQueueProperties() {
        return this.queueProperties;
    }

    public Consumer<Object> getDelegate() {
        return this.delegate;
    }
}

