/*
 * Decompiled with CFR 0.152.
 */
package vip.justlive.rabbit.consumer;

import com.rabbitmq.client.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.amqp.support.converter.MessageConverter;
import vip.justlive.rabbit.consumer.ConsumerDef;

public class Receiver
implements ChannelAwareMessageListener {
    private static final Logger log = LoggerFactory.getLogger(Receiver.class);
    private final MessageConverter converter;

    public void onMessage(Message message, Channel channel) throws Exception {
        try {
            MessageProperties prop = message.getMessageProperties();
            ConsumerDef consumer = ConsumerDef.lookup(prop.getConsumerQueue(), prop.getReceivedExchange(), prop.getReceivedRoutingKey());
            if (consumer == null) {
                log.error("consumer not found {}", (Object)prop);
                channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
                return;
            }
            Object msg = this.converter.fromMessage(message);
            if (log.isDebugEnabled()) {
                log.debug("receive msg {}", msg);
            }
            consumer.accept(msg);
            channel.basicAck(message.getMessageProperties().getDeliveryTag(), false);
        }
        catch (Exception e) {
            log.error("receive msg error {}", (Object)message, (Object)e);
            channel.basicNack(message.getMessageProperties().getDeliveryTag(), false, false);
        }
    }

    public Receiver(MessageConverter converter) {
        this.converter = converter;
    }
}

